-- Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved.
--
-- this file licensed under the Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND, EITHER EXPRESS OR
-- IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT, MERCHANTABILITY OR FIT FOR A PARTICULAR
-- PURPOSE.
-- See the Mulan PSL v2 for more details.
--
-- Author: auto generate
-- Create: 2025-4-28
-- Description: DO NOT EDIT; Code generated by "db.lua.mako"
local Databases = require 'database'
local Col = require 'database.column'

---@class ObservabilityServiceTable: Table
---@field Enabled FieldBase
---@field TLSMode FieldBase
---@field ServerIdentity FieldBase
---@field Id FieldBase

---@class ReceiversTable: Table
---@field ReceiverId FieldBase
---@field Enabled FieldBase
---@field Address FieldBase
---@field Port FieldBase
---@field Protocol FieldBase

---@class ObservabilityDBDatabase
---@field db DataBase
---@field select fun(db:DataBase, table: any, ...): SelectStatement
---@field update fun(db:DataBase, table: any, ...): UpdateStatement
---@field insert fun(db:DataBase, table: any, ...): InsertStatement
---@field ObservabilityService ObservabilityServiceTable
---@field Receivers ReceiversTable
local ObservabilityDBDatabase = {}
ObservabilityDBDatabase.__index = ObservabilityDBDatabase

function ObservabilityDBDatabase.new(path, datas)
    local db = Databases(path)
    local obj = {db = db}

    obj.ObservabilityService = db:Table('t_observability', {
        Enabled = Col.BooleandField():cid(1):persistence_key('protect_power_off'):null():default(false),
        TLSMode = Col.TextField():cid(2):persistence_key('protect_power_off'):null():default('\'TLS\''),
        ServerIdentity = Col.TextField():cid(3):persistence_key('protect_power_off'):null():default('\'BoardSN\''),
        Id = Col.IntegerField():cid(4):primary_key():persistence_key('protect_power_off'):max_length(8)
    }, 'protect_power_off'):create_if_not_exist(datas and datas['t_observability'])
    obj.Receivers = db:Table('t_observability_receivers', {
        ReceiverId = Col.IntegerField():cid(1):primary_key():persistence_key('protect_power_off'):max_length(8):default(
            0),
        Enabled = Col.BooleandField():cid(2):persistence_key('protect_power_off'):null():default(false),
        Address = Col.TextField():cid(3):persistence_key('protect_power_off'):null():default('\'\''),
        Port = Col.IntegerField():cid(4):persistence_key('protect_power_off'):null():max_length(16):default(0),
        Protocol = Col.TextField():cid(5):persistence_key('protect_power_off'):null():default('\'OtlpHttp\'')
    }, 'protect_power_off'):create_if_not_exist(datas and datas['t_observability_receivers'])

    obj.tables = db.tables
    return setmetatable(obj, ObservabilityDBDatabase)
end

function ObservabilityDBDatabase:select(table, ...)
    return self.db:select(table, ...)
end

function ObservabilityDBDatabase:update(table, ...)
    return self.db:update(table, ...)
end

function ObservabilityDBDatabase:insert(table, ...)
    return self.db:insert(table, ...)
end

function ObservabilityDBDatabase:delete(table, ...)
    return self.db:delete(table, ...)
end

function ObservabilityDBDatabase:exec(...)
    return self.db:exec(...)
end

return ObservabilityDBDatabase.new
