-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local vos = require 'utils.vos'
local skynet = require 'skynet'
local dfx_defs = require 'dfx_collect.dfx_defs'
local c_optical_module_dfx = require 'dfx_collect.optical_module_dfx'
local file_sec = require 'utils.file'
local lu = require 'luaunit'
local utils = require 'mc.utils'

local DEFAULT_MSG_TYPE<const> = 0xff

TEST_optical_module_dfx = {}

local function create_link_down_msg()
    -- 使用一条从以往的光模块日志收集的linkdown信息
    local linkdown_msg = {
        log_time = 22, npu_id = 2,
        component = dfx_defs.component.OPTICAL_MODULE,
        msg_type = dfx_defs.optical_module.LINKDOWN,
        timestamp = 22,
        vcc_current = 32608,
        tx_power = {12531, 13156, 12503, 12827, 0, 0, 0, 0},
        rx_power = {12190, 12247, 8507, 12917, 0, 0, 0, 0},
        bias = {7934, 7928, 7936, 7928, 0, 0, 0, 0},
        tx_los = 7, rx_los = 7,
        tx_lol = 14, rx_lol = 14,
        temperature = 36, tx_fault = 4,
        host_snr = {21.566, 21.566, 21.566, 21.566, 21.566,
        21.566, 21.566, 21.566},
        media_snr = {21.566, 21.566, 21.566, 21.566, 21.566,
        21.566, 21.566, 21.566}
    }
    return linkdown_msg
end

local function create_link_down_elec_msg()
    -- 使用一条从以往的光模块日志收集的linkdown信息
    local linkdown_elec_msg = {
        log_time = 22, npu_id = 2,
        component = dfx_defs.component.OPTICAL_MODULE,
        msg_type = dfx_defs.optical_module.ELECTRIC_LINKDOWN,
        timestamp = 22,
        npu_rx_snr = {12531, 13156, 12503, 12827, 0, 0, 0, 0},
        pcs_err_cnt = 1,
        cw_before_correct_cnt = 2,
        cw_correct_cnt = 3,
        cw_uncorrect_cnt = 4,
        cdr_host_snr = {21.566, 21.566, 21.566, 21.566, 21.566,
        21.566, 21.566, 21.566},
        cdr_media_snr = {21.566, 21.566, 21.566, 21.566, 21.566,
        21.566, 21.566, 21.566}
    }
    return linkdown_elec_msg
end

function TEST_optical_module_dfx:test_needs_header()
    local linkdown_msg = create_link_down_msg()
    local msg_type = linkdown_msg.msg_type
    local dfx_obj_defult = {
        msg_type = DEFAULT_MSG_TYPE
    }
    local dfx_obj_period = {
        msg_type = dfx_defs.optical_module.PERIOD
    }
    local file_length = 1024
    rsp1 = c_optical_module_dfx.mock_needs_header(msg_type, dfx_obj_defult, file_length)
    lu.assertEquals(rsp1, true)
    rsp2 = c_optical_module_dfx.mock_needs_header(msg_type, dfx_obj_period, file_length)
    lu.assertEquals(rsp2, false)
end

function TEST_optical_module_dfx:test_parse_optical_module_info()
    local linkdown_elec_msg = create_link_down_elec_msg()
    local dfx_obj_defult = {
        msg_type = DEFAULT_MSG_TYPE,
        linkdown_timer = {
            day_timer = {
                [0] = {
                    all_module_log_cnt = 0
                },
                [2] = {
                    all_module_log_cnt = 0
                },
                timestamp = 0
            },
            hour_timer = {
                [0] = {
                    per_module_log_cnt = {},
                    all_module_log_cnt = 0
                },
                [2] = {
                    per_module_log_cnt = {},
                    all_module_log_cnt = 0
                },
                timestamp = 0
            }
        }
    }
    local ok, _ = pcall(function()
        c_optical_module_dfx.mock_parse_optical_module_info(
            linkdown_elec_msg, dfx_obj_defult)
    end)
    lu.assertEquals(ok, true)
end

return linkdown_msg_handler