-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local metric_collect = require 'metric.metric_collect'
local c_optical_module = require 'device.class.optical_module'
local c_network_port = require 'device.class.network_port'


TEST_metric_collect = {}

local object = {
    ['RxPowerMilliWatts'] = {1, 2, 3},
    ['TxPowerMilliWatts'] = {1, 2, 3},
    ['BiasCurrentMilliAmps'] = {1, 2, 3},
    ['TemperatureCel'] = 255,
    ['VoltageMilliVoltage'] = 255,
    ['RxLoss'] = 0,
    ['TxLoss'] = 0,
    ['MacRxFcsErrPktNum'] = 0,
    ['MacRxTotalPktNum'] = 0,
    ['RxLossOfLock'] = 0,
    ['TxLossOfLock'] = 0,
    ['LaserRuntimeSeconds'] = 0,
    ['UptimeSeconds'] = 0,
    ['PowerOnCount'] = 0,
    ['PowerStatus'] = 1,
    ['OdspDieTemperatureCelsius'] = 255,
    ['OdspHighTempRuntimeSeconds'] = 0,
    ['LaserTemperatureCelsius'] = 255,
    ['CorrectableFECErrors'] = 0,
    ['UnCorrectableFECErrors'] = 0,
    ['MediaSNR'] = {1, 2, 3},
    ['HostSNR'] = {1, 2, 3}
}
local mock_collection = c_optical_module.collection.find

function TEST_metric_collect:setUp()
    c_optical_module.collection.find = function()
        return object
    end
end

function TEST_metric_collect:teardown()
    c_optical_module.collection.find = mock_collection
end

function TEST_metric_collect:test_get_metric_data()
    local metric_name = {"opticalmodule.metric"}
    metric_collect:get_metric_data(object, metric_name)
end