-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
skynet = require 'skynet'
local c_link_log_collection = require 'device.class.npu_port_link_log_collection'
local file_sec = require 'utils.file'
local utils_core = require 'utils.core'

TEST_npu_port_link_log_collection = {}

local mock_log_collection = {
    npu_ports_hccs_info = {}
}
local mock_network_ports = {
    {
        get_npu_port_hccs_record = function()
            return {
                npu_id = 1,
                health_status = 0,
                lane_mode = {},
                link_lane_list = {},
                link_speed = {},
                tx_packets = {},
                tx_bytes = {},
                rx_packets = {},
                rx_bytes = {},
                retry_count = {},
                error_count = {},
                first_error_lane = 255,
                snr_max = {{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
                    {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
                snr_min = {{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
                    {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
                half_height_max = {{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
                    {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}},
                half_height_min = {{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0},
                    {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}
            }
        end
    }
}


function TEST_npu_port_link_log_collection:test_update_hccs_info()
    c_link_log_collection.update_hccs_info(mock_log_collection, mock_network_ports)
    lu.assertEquals(#mock_log_collection.npu_ports_hccs_info, 1)
end

function TEST_npu_port_link_log_collection:test_update_buffer_to_file()
    c_link_log_collection.log_collection = {}
    c_link_log_collection.log_collection.write_file_flag = true
    local ret, _ = pcall(c_link_log_collection.update_buffer_to_file, c_link_log_collection)
    lu.assertEquals(ret, false)
end

function TEST_npu_port_link_log_collection:test_update_hccs_info_to_file()
    mock_log_collection.npu_ports_hccs_info = {
        {
            npu_id = 1,
            health_status = 'NOK',
            lane_mode = '',
            link_lane_list = '',
            link_speed = '',
            tx_packets = '',
            tx_bytes = '',
            rx_packets = '',
            rx_bytes = '',
            retry_count = '',
            error_count = '',
            first_error_lane = 2,
            snr_max = '',
            snr_min = '',
            half_height_max = '',
            half_height_min = ''
        }
    }
    local open_s = file_sec.open_s
    local chmod_s = utils_core.chmod_s
    file_sec.open_s = function()
        return {
            read = function()
                return ''
            end,
            write = function()
                return ''
            end,
            close = function()
                return true
            end
        }
    end
    ok, _ = pcall(function() 
        c_link_log_collection.update_hccs_info_to_file(mock_log_collection)
    end)
    lu.assertEquals(ok, true)
    file_sec.open_s = open_s
    utils_core.chmod_s = chmod_s
end
