-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require('luaunit')

-- 记录原始依赖
local orig_om_npu = package.loaded['device.class.nic_mgmt.om.om_npu']
local orig_om_property_listen = package.loaded['device.class.nic_mgmt.om.om_property_listen']
local orig_om_cpu = package.loaded['device.class.nic_mgmt.om.om_cpu']

-- mock om_npu依赖，必须在require om_manage之前
local called = { npu = false }
package.loaded['device.class.nic_mgmt.om.om_npu'] = {
    init = function(orm_obj, npu_id) called.npu = {orm_obj = orm_obj, npu_id = npu_id} end
}
-- mock其它依赖，避免require报错
package.loaded['device.class.nic_mgmt.om.om_property_listen'] = { register_property_changed_callback = function() end }
package.loaded['device.class.nic_mgmt.om.om_cpu'] = { start_get_optical_info_task = function() end }

local om_manage = require 'device.class.nic_mgmt.om.om_manage'

TestOmManage = {}

function TestOmManage:tearDown()
    package.loaded['device.class.nic_mgmt.om.om_npu'] = orig_om_npu
    package.loaded['device.class.nic_mgmt.om.om_property_listen'] = orig_om_property_listen
    package.loaded['device.class.nic_mgmt.om.om_cpu'] = orig_om_cpu
end

function TestOmManage:test_init_npu_optical()
    called.npu = false
    local orm_obj = { id = 123 }
    om_manage.init_npu_optical(orm_obj, 88)
    lu.assertNotNil(called.npu)
    lu.assertIs(called.npu.orm_obj, orm_obj)
    lu.assertEquals(called.npu.npu_id, 88)
end 