-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require('luaunit')

-- 记录原始依赖
local orig_port_defs = package.loaded['device.class.nic_mgmt.port.port_defs']
local orig_om_manage = package.loaded['device.class.nic_mgmt.om.om_manage']

-- mock port_defs
package.loaded['device.class.nic_mgmt.port.port_defs'] = { NPU_MODEL = 'NPU' }
-- mock om_manage
local called = { npu = false, reg = false, start = false }
package.loaded['device.class.nic_mgmt.om.om_manage'] = {
    init_npu_optical = function(orm_obj, npuid) called.npu = {orm_obj = orm_obj, npuid = npuid} end,
    register_property_changed_callback = function(orm_obj) called.reg = orm_obj end,
    start_get_optical_info_task = function(orm_obj) called.start = orm_obj end,
}

local om_init = require 'device.class.nic_mgmt.om.om_init'

TestOmInit = {}

function TestOmInit:tearDown()
    -- 恢复mock依赖，避免影响其它用例
    package.loaded['device.class.nic_mgmt.port.port_defs'] = orig_port_defs
    package.loaded['device.class.nic_mgmt.om.om_manage'] = orig_om_manage
end

function TestOmInit:test_init_npu_model()
    called.npu, called.reg, called.start = false, false, false
    local orm_obj = {
        NetworkAdapterId = 'NA1',
        PortID = 2,
        parent = {
            PortID = 2,
            NpuID = 99,
            parent = {
                Model = 'NPU',
                SlotNumber = 7
            }
        }
    }
    om_init.init(orm_obj)
    lu.assertEquals(orm_obj.channel_num, 3)
    lu.assertNotNil(called.npu)
    lu.assertEquals(called.npu.npuid, 99)
    lu.assertFalse(called.reg)
    lu.assertFalse(called.start)
end

function TestOmInit:test_init_non_npu_model()
    called.npu, called.reg, called.start = false, false, false
    local orm_obj = {
        NetworkAdapterId = 'NA2',
        PortID = 1,
        parent = {
            PortID = 1,
            parent = {
                Model = 'OTHER',
                SlotNumber = 8
            }
        }
    }
    om_init.init(orm_obj)
    lu.assertEquals(orm_obj.channel_num, 2)
    lu.assertFalse(called.npu)
    lu.assertEquals(called.reg, orm_obj)
    lu.assertEquals(called.start, orm_obj)
end 