-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require('luaunit')
local card_manage = require 'device.class.nic_mgmt.card.card_manage'

TestCardManage = {}

function TestCardManage:test_init_asset_data_info_normal()
    local listens = {}
    local orm_obj = {
        Type = 1,
        Name = 'NIC-1',
        SerialNumber = 'SN123',
        FirmwareVersion = 'FW1.0',
        PCBVersion = 'PCB1',
        Manufacturer = 'Huawei',
        SlotNumber = 2,
        children = {},
        listen = function(self, prop, cb)
            listens[prop] = cb
        end
    }
    card_manage.init_asset_data_info(orm_obj)
    lu.assertEquals(orm_obj.AssetType, 'NetworkAdapter')
    lu.assertEquals(orm_obj.AssetName, 'NIC-1')
    lu.assertEquals(orm_obj.InventorySerialNumber, 'SN123')
    lu.assertEquals(orm_obj.InventoryFirmwareVersion, 'FW1.0')
    lu.assertEquals(orm_obj.InventoryPCBVersion, 'PCB1')
    lu.assertEquals(orm_obj.InventoryManufacturer, 'Huawei')
    lu.assertEquals(orm_obj.AssetTag, 'N/A')
    lu.assertEquals(orm_obj.PartNumber, 'N/A')
    lu.assertEquals(orm_obj.ManufactureDate, 'N/A')
    lu.assertEquals(orm_obj.Slot, '2')
    lu.assertEquals(orm_obj.UUID, '')
    -- 检查监听项
    lu.assertNotNil(listens.Name)
    lu.assertNotNil(listens.SerialNumber)
    lu.assertNotNil(listens.FirmwareVersion)
    lu.assertNotNil(listens.PCBVersion)
    lu.assertNotNil(listens.Manufacturer)
    lu.assertNotNil(listens.SlotNumber)
end

function TestCardManage:test_init_asset_data_info_virtual_port()
    local listens = {}
    local orm_obj = { Type = 6, children = {}, listen = function(self, prop, cb) listens[prop] = cb end }
    card_manage.init_asset_data_info(orm_obj)
    -- 虚拟端口直接return，不设置资产信息，也不注册监听
    lu.assertNil(orm_obj.AssetType)
    lu.assertNil(orm_obj.AssetName)
    lu.assertNil(orm_obj.InventorySerialNumber)
    lu.assertEquals(next(listens), nil)
end