-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require('luaunit')

local card_init_id = require 'device.class.nic_mgmt.card.card_init_id'

TestCardInitId = {}

function TestCardInitId:test_init_id_virtual_port()
    local orm_obj = { Type = 6, BoardID = 0x1234,
        tasks = { sleep_ms = function() end }, register_mdb_objects = function() end }
    card_init_id.init_id(orm_obj)
    -- 虚拟端口直接return，不设置ID
    lu.assertNil(orm_obj.ID)
    lu.assertNil(orm_obj.NodeId)
end

function TestCardInitId:test_init_id_normal()
    local called = { reg = false, listen = false }
    local orm_obj = {
        Type = 1,
        BoardID = 0x1234,
        DeviceLocator = 'devA',
        Position = 'posA',
        SocketId = 0,
        Bus = 1, Device = 2, Function = 3,
        DevBus = 4, DevDevice = 5, DevFunction = 6,
        tasks = { sleep_ms = function() end },
        register_mdb_objects = function() called.reg = true end,
        listen = function(self, prop, cb)
            called.listen = true
        end
    }
    card_init_id.init_id(orm_obj)
    lu.assertEquals(orm_obj.BoardIDHex, '0x1234')
    lu.assertEquals(orm_obj.ID, 'posAdevA')
    lu.assertEquals(orm_obj.NodeId, 'posAdevA')
    lu.assertTrue(called.reg)
    lu.assertTrue(called.listen)
    -- 检查部分属性被赋值
    lu.assertNotNil(orm_obj.AssociatedResource)
end
