-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local vos = require 'utils.vos'
local skynet = require 'skynet'
local dfx_defs = require 'dfx_collect.dfx_defs'
local dfx_collect = require 'dfx_collect.dfx_collect_mgnt'
local file_sec = require 'utils.file'
local lu = require 'luaunit'
local utils = require 'mc.utils'

local linkdown_msg_handler = {}

local function create_link_down_msg()
    -- 使用一条从以往的光模块日志收集的linkdown信息
    local linkdown_msg = {
        log_time = 22, npu_id = 2,
        component = dfx_defs.component.OPTICAL_MODULE,
        msg_type = dfx_defs.optical_module.LINKDOWN,
        timestamp = 22,
        vcc_current = 32608,
        tx_power = {12531, 13156, 12503, 12827, 0, 0, 0, 0},
        rx_power = {12190, 12247, 8507, 12917, 0, 0, 0, 0},
        bias = {7934, 7928, 7936, 7928, 0, 0, 0, 0},
        tx_los = 7, rx_los = 7,
        tx_lol = 14, rx_lol = 14,
        temperature = 36, tx_fault = 4,
        host_snr = {21.566, 21.566, 21.566, 21.566, 21.566,
        21.566, 21.566, 21.566},
        media_snr = {21.566, 21.566, 21.566, 21.566, 21.566,
        21.566, 21.566, 21.566}
    }
    return linkdown_msg
end

function linkdown_msg_handler.test_optical_module_linkdown_msg_handler()
    log:notice('====================== test_optical_module_linkdown_msg_handler start ===========')
    local linkdown_msg = create_link_down_msg()
    -- 设置环境变量
    local test_data_dir = '/tmp/'
    dfx_defs.optical_module_file_info.PATH = test_data_dir
    dfx_defs.optical_module_file_info.FILE_PATH = test_data_dir .. '/' .. 'optical_module_history_info_log.csv'

    -- 拉起对应的消息队列
    dfx_collect.new()
    dfx_collect.get_instance():init()
    dfx_collect.get_instance():msg_productor(linkdown_msg)

    -- 等待2s读取创建的日志文件
    skynet.sleep(200)
    -- 读取文件
    local fp = file_sec.open_s(test_data_dir .. 'optical_module_history_info_log.csv', 'r')
    assert(fp ~= nil, "open log file failed")
    local base_log_path = skynet.getenv('LINKDOWN_LOG_PATH')

    -- 由于是第一条信息，首先校验表头
    local log_line = fp:read()
    local base_log = io.open(base_log_path,"r")
    local header_line = base_log:read()
    lu.assertEquals(log_line, header_line)

    -- 校验Linkdown的对应的handler的信息
    log_line = fp:read()
    -- 过滤时间信息，不作比较
    log_line = string.gsub(log_line, '%d%d%d%d%-%d%d%-%d%d %d%d:%d%d:%d%d', '')
    local target_log_line = base_log:read()
    target_log_line = string.gsub(target_log_line, '%d%d%d%d%-%d%d%-%d%d %d%d:%d%d:%d%d', '')
    lu.assertEquals(log_line, target_log_line)

    fp:close()
    io.close(base_log)

    -- 准备待测文件
    for i = 1, dfx_defs.optical_module_file_info.COMPRESS_NUM - 1 do
        file_name = test_data_dir .. 'optical_module_history_info_log' .. i .. '.tar.gz'
        local fp = io.open(file_name,"w")
        lu.assertEquals(fp ~= nil, true)
        io.close(fp)
    end

    -- 测试接口 move_log
    dfx_defs.optical_module_file_info.FILE_SIZE = 0
    local optical_module = dfx_collect.get_instance().optical_module
    ret = pcall(optical_module.optical_module_dfx_hander, optical_module, linkdown_msg)
    lu.assertEquals(ret, true)

    -- 清除相关文件
    utils.remove_file(dfx_defs.optical_module_file_info.FILE_PATH)
    for i = 1, dfx_defs.optical_module_file_info.COMPRESS_NUM do
        dst_file = test_data_dir .. 'optical_module_history_info_log' .. i .. '.tar.gz'
        utils.remove_file(dst_file)
    end
    log:notice('====================== test_optical_module_linkdown_msg_handler complete ===========')
end

return linkdown_msg_handler