-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: dfx日志收集

local skynet = require 'skynet'
local optical_module_dfx = require 'dfx_collect.optical_module_dfx'
local dfx_defs = require 'dfx_collect.dfx_defs'
local singleton = require 'mc.singleton'
local dfx_collect_mgnt = {}
dfx_collect_mgnt.__index = dfx_collect_mgnt
local function dfx_msg_handler(dfx_msg, collect_obj)
    if dfx_msg.component == dfx_defs.component.OPTICAL_MODULE then
        collect_obj.optical_module:optical_module_dfx_hander(dfx_msg)
    end
end
local function dfx_msg_consumer(collect_obj)
    local queue = collect_obj.dfx_msg_queue
    while true do
        if #queue > 0 then
            dfx_msg_handler(queue[1], collect_obj)
            table.remove(queue, 1)
        else
            skynet.wait()
        end
    end
end

function dfx_collect_mgnt:msg_productor(dfx_msg)
    table.insert(self.dfx_msg_queue, dfx_msg)
    if #self.dfx_msg_queue == 1 then
        skynet.wakeup(self.dfx_consumer)
    end
end

function dfx_collect_mgnt:init()
    self.dfx_consumer = skynet.fork_loop({count = 0}, dfx_msg_consumer, self)
end

function dfx_collect_mgnt.new()
    return setmetatable({
        dfx_consumer = nil,
        dfx_msg_queue = {},
        optical_module = optical_module_dfx.new()
    }, dfx_collect_mgnt)
end

return singleton(dfx_collect_mgnt)