-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local port_defs = require 'device.class.nic_mgmt.port.port_defs'
local c_network_port = require 'device.class.network_port'

local port_property_listen = {}

local property_changed_switch<const> = {
    LinkStatus = c_network_port.update_link_status,
    LinkStatusNumeric = c_network_port.synchronize_link_status,
    LLDPEnabled = c_network_port.set_LLDP_capability,
    PermanentMACAddress = c_network_port.emit_mac_change_signal
}

function port_property_listen.register_property_changed_callback(orm_obj)
    local link_status = orm_obj.LinkStatusNumeric == 1 and 'Connected' or
        orm_obj.LinkStatusNumeric == 0 and 'Disconnected' or port_defs.INVALID_DATA_STRING
    orm_obj:set_link_status(link_status)
    orm_obj:connect_signal(orm_obj.on_property_changed, function(name, value)
        if property_changed_switch[name] then
            orm_obj:next_tick(property_changed_switch[name], orm_obj, value)
        end
    end)
end

return port_property_listen