-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local singleton = require 'mc.singleton'
local card_mgmt = require 'device.class.nic_mgmt.card_mgmt'
local port_mgmt = require 'device.class.nic_mgmt.port_mgmt'
local om_mgmt = require 'device.class.nic_mgmt.om_mgmt'

local m = class()

function m:ctor(bus)
    self.bus = bus
end

function m:init()
    card_mgmt.new(self.bus)
    port_mgmt.new(self.bus)
    om_mgmt.new(self.bus)
end

return singleton(m)