-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local comm_defs = {}

comm_defs.MACA_SERVICE = 'bmc.kepler.maca'
comm_defs.MDB_PATH = '/bmc/kepler/MdbService'
comm_defs.MDB_INTERFACE = 'bmc.kepler.Mdb'

comm_defs.CARD_DEVICE_PATH_PATTERN = '/bmc/dev/Systems/1/PCIeNicCard'

-- 网卡相关设备树接口
comm_defs.PCIE_DEVICE_INTERFACE = 'bmc.dev.PCIeDevice'
comm_defs.PCIE_CARD_DEVICE_INTERFACE = 'bmc.dev.PCIeCard'
comm_defs.PCIE_DEVICE_HOT_SWAP_INTERFACE = 'bmc.dev.PCIeDevice.HotSwap'
comm_defs.PCIE_DEVICE_BANDWIDTH_INTERFACE = 'bmc.dev.PCIeDevice.Bandwidth'
comm_defs.BOARD_DEVICE_INTERFACE = 'bmc.dev.Board'
comm_defs.NETWORK_ADAPTER_DEVICE_INTERFACE = 'bmc.dev.NetworkAdapter'
comm_defs.NETWORK_ADAPTER_DEVICE_COOLING_INTERFACE = 'bmc.dev.NetworkAdapter.Cooling'
comm_defs.NETWORK_ADAPTER_DEVICE_FAULT_STATUS_INTERFACE = 'bmc.dev.NetworkAdapter.FaultStatus'
comm_defs.NETWORK_ADAPTER_DEVICE_LOG_COLLECTION_INTERFACE = 'bmc.dev.NetworkAdapter.LogCollection'

-- 网口相关设备树接口
comm_defs.NETWORK_PORT_DEVICE_INTERFACE = 'bmc.dev.NetworkPort'
comm_defs.NETWORK_PORT_DATA_CENTER_BRIDGING_INTERFACE = 'bmc.dev.NetworkPort.DataCenterBridging'
comm_defs.NETWORK_PORT_LLDP_RECEIVE_INTERFACE = 'bmc.dev.NetworkPort.LLDPReceive'
comm_defs.NETWORK_PORT_LINK_INFO_INTERFACE = 'bmc.dev.NetworkPort.LinkInfo'
comm_defs.NETWORK_PORT_METRICS_INTERFACE = 'bmc.dev.NetworkPort.Metrics'

-- 光模块相关设备树接口
comm_defs.OPTICAL_MODULE_DEVICE_INTERFACE = 'bmc.dev.OpticalModule'
comm_defs.OPTICAL_MODULE_STATUS_INTERFACE = 'bmc.dev.OpticalModule.Status'
comm_defs.OPTICAL_MODULE_COOLING_INTERFACE = 'bmc.dev.OpticalModule.Cooling'

comm_defs.COMMON_PROPERTIES_INTERFACE = 'bmc.kepler.Object.Properties'
comm_defs.ORG_PROPERTIES_INTERFACE = 'org.freedesktop.DBus.Properties'

comm_defs.INTERFACE_REGISTER_TABLE = {
    [comm_defs.NETWORK_ADAPTER_DEVICE_INTERFACE] = {
        OSPowerState = {'y', nil, false, nil, false}
    },
    [comm_defs.PCIE_CARD_DEVICE_INTERFACE] = {
        Health = {'y', nil, false, nil, false}
    },
    [comm_defs.PCIE_DEVICE_INTERFACE] = {
        DeviceName = {'s', nil, true, nil, false}
    }
}

comm_defs.LOG_DUMP_BUSY = 1 -- 1表示正在收集
comm_defs.LOG_DUMP_IDLE = 0 -- 0 表示空闲

return comm_defs
