-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local c_handler_base = require 'bma.handles.handler_base'
local c_optical_module = require 'device.class.optical_module'
local c_handler_optical = require 'bma.handles.handler_optical'
local singleton = require 'mc.singleton'
local get_value_to_update = c_handler_base.get_value_to_update
local update_presence = c_handler_optical.update_presence

local get_odata_id = c_handler_base.get_odata_id

local c_handler_optical_diag = class(c_handler_base)

function c_handler_optical_diag:ctor()
end

function c_handler_optical_diag:init()
    self:regist_odata_type('OemEthernetInterfaceSffDiagnostic')
    self:regist_odata_type('OemInfiniBandSffDiagnostic')
    self:regist_odata_type('OemFCSffDiagnostic')

    self:regist_class_type(c_optical_module)

    c_handler_optical.get_instance().on_need_update:on(function(object, path)
        self:match_resource(object, path)
    end)
end

function c_handler_optical_diag:find_object(_, data)
    local optical_bma_id = self.get_parent_path(get_odata_id(data))
    return c_handler_optical.get_instance():get_object(optical_bma_id)
end

function c_handler_optical_diag:update_optical_diag(op, data)
    op.get_diagnostic_by_ibma_success = true
    if op and op:check_port_workload_type() then
        return
    end
    local default = 65535
    local default_arr = {}
    local default_num = 0
    -- bmc.kepler.Systems.OpticalModule.Temperature
    op.ReadingCelsius = get_value_to_update(op.ReadingCelsius, data.TempCurrentCelsius, default)
    op.TemperatureUpperThresholdCritical = get_value_to_update(op.TemperatureUpperThresholdCritical,
        data.TempHighAlarmCelsius, default)
    op.TemperatureLowerThresholdCritical = get_value_to_update(op.TemperatureLowerThresholdCritical,
        data.TempLowAlarmCelsius, default)

    -- bmc.kepler.Systems.OpticalModule.Voltage
    op.SupplyVoltage = get_value_to_update(op.SupplyVoltage, data.VccCurrentVolts, default)
    op.VoltageUpperThresholdCritical = get_value_to_update(op.VoltageUpperThresholdCritical,
        data.VccHighAlarmVolts, default)
    op.VoltageLowerThresholdCritical = get_value_to_update(op.VoltageLowerThresholdCritical,
        data.VccLowAlarmVolts, default)

    -- bmc.kepler.Systems.OpticalModule.BiasCurrent
    op.TXBiasCurrentMilliAmps = get_value_to_update(op.TXBiasCurrentMilliAmps,
        data.TxBiasCurrentMilliampere, default_arr)
    op.BC_TXUpperThresholdCritical = get_value_to_update(op.BC_TXUpperThresholdCritical,
        data.TxBiasHighAlarmMilliampere, default)
    op.BC_TXLowerThresholdCritical = get_value_to_update(op.BC_TXLowerThresholdCritical,
        data.TxBiasLowAlarmMilliampere, default)

    -- bmc.kepler.Systems.OpticalModule.Power
    op.TXOutputPowerMilliWatts = get_value_to_update(op.TXOutputPowerMilliWatts,
        data.TxPowerCurrentMilliwatt, default_arr)
    op.Power_TXUpperThresholdCritical = get_value_to_update(op.Power_TXUpperThresholdCritical,
        data.TxPowerHighAlarmMilliwatt, default)
    op.Power_TXLowerThresholdCritical = get_value_to_update(op.Power_TXLowerThresholdCritical,
        data.TxPowerLowAlarmMilliwatt, default)
    op.RXInputPowerMilliWatts = get_value_to_update(op.RXInputPowerMilliWatts,
        data.RxPowerCurrentMilliwatt, default_arr)
    op.RXUpperThresholdCritical = get_value_to_update(op.RXUpperThresholdCritical,
        data.RxPowerHighAlarmMilliwatt, default)
    op.RXLowerThresholdCritical = get_value_to_update(op.RXLowerThresholdCritical,
        data.RxPowerLowAlarmMilliwatt, default)
    op.Presence = update_presence(op.Presence, data.IsSffExist, default_num)
end

function c_handler_optical_diag:reset()
    for object, _ in pairs(self.objects) do
        object:reset_bma_stats()
    end
end

function c_handler_optical_diag:add(_, data, object)
    self:update_optical_diag(object, data)
end

function c_handler_optical_diag:update(_, data, object)
    self:update_optical_diag(object, data)
end

return singleton(c_handler_optical_diag)
