-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Voltage = {}

---@class Voltage.VoltageUpperThresholdWarning
---@field VoltageUpperThresholdWarning number
local TVoltageUpperThresholdWarning = {}
TVoltageUpperThresholdWarning.__index = TVoltageUpperThresholdWarning
TVoltageUpperThresholdWarning.group = {}

local function TVoltageUpperThresholdWarning_from_obj(obj)
    return setmetatable(obj, TVoltageUpperThresholdWarning)
end

function TVoltageUpperThresholdWarning.new(VoltageUpperThresholdWarning)
    return
        TVoltageUpperThresholdWarning_from_obj({VoltageUpperThresholdWarning = VoltageUpperThresholdWarning or 65535})
end
---@param obj Voltage.VoltageUpperThresholdWarning
function TVoltageUpperThresholdWarning:init_from_obj(obj)
    self.VoltageUpperThresholdWarning = obj.VoltageUpperThresholdWarning or 65535
end

function TVoltageUpperThresholdWarning:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVoltageUpperThresholdWarning.group)
end

TVoltageUpperThresholdWarning.from_obj = TVoltageUpperThresholdWarning_from_obj

TVoltageUpperThresholdWarning.proto_property = {'VoltageUpperThresholdWarning'}

TVoltageUpperThresholdWarning.default = {0}

TVoltageUpperThresholdWarning.struct = {{name = 'VoltageUpperThresholdWarning', is_array = false, struct = nil}}

function TVoltageUpperThresholdWarning:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VoltageUpperThresholdWarning', self.VoltageUpperThresholdWarning, 'double', true, errs,
        need_convert)

    TVoltageUpperThresholdWarning:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVoltageUpperThresholdWarning.proto_property, errs, need_convert)
    return self
end

function TVoltageUpperThresholdWarning:unpack(_)
    return self.VoltageUpperThresholdWarning
end

Voltage.VoltageUpperThresholdWarning = TVoltageUpperThresholdWarning

---@class Voltage.VoltageLowerThresholdWarning
---@field VoltageLowerThresholdWarning number
local TVoltageLowerThresholdWarning = {}
TVoltageLowerThresholdWarning.__index = TVoltageLowerThresholdWarning
TVoltageLowerThresholdWarning.group = {}

local function TVoltageLowerThresholdWarning_from_obj(obj)
    return setmetatable(obj, TVoltageLowerThresholdWarning)
end

function TVoltageLowerThresholdWarning.new(VoltageLowerThresholdWarning)
    return
        TVoltageLowerThresholdWarning_from_obj({VoltageLowerThresholdWarning = VoltageLowerThresholdWarning or 65535})
end
---@param obj Voltage.VoltageLowerThresholdWarning
function TVoltageLowerThresholdWarning:init_from_obj(obj)
    self.VoltageLowerThresholdWarning = obj.VoltageLowerThresholdWarning or 65535
end

function TVoltageLowerThresholdWarning:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVoltageLowerThresholdWarning.group)
end

TVoltageLowerThresholdWarning.from_obj = TVoltageLowerThresholdWarning_from_obj

TVoltageLowerThresholdWarning.proto_property = {'VoltageLowerThresholdWarning'}

TVoltageLowerThresholdWarning.default = {0}

TVoltageLowerThresholdWarning.struct = {{name = 'VoltageLowerThresholdWarning', is_array = false, struct = nil}}

function TVoltageLowerThresholdWarning:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VoltageLowerThresholdWarning', self.VoltageLowerThresholdWarning, 'double', true, errs,
        need_convert)

    TVoltageLowerThresholdWarning:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVoltageLowerThresholdWarning.proto_property, errs, need_convert)
    return self
end

function TVoltageLowerThresholdWarning:unpack(_)
    return self.VoltageLowerThresholdWarning
end

Voltage.VoltageLowerThresholdWarning = TVoltageLowerThresholdWarning

---@class Voltage.VoltageUpperThresholdCritical
---@field VoltageUpperThresholdCritical number
local TVoltageUpperThresholdCritical = {}
TVoltageUpperThresholdCritical.__index = TVoltageUpperThresholdCritical
TVoltageUpperThresholdCritical.group = {}

local function TVoltageUpperThresholdCritical_from_obj(obj)
    return setmetatable(obj, TVoltageUpperThresholdCritical)
end

function TVoltageUpperThresholdCritical.new(VoltageUpperThresholdCritical)
    return TVoltageUpperThresholdCritical_from_obj({
        VoltageUpperThresholdCritical = VoltageUpperThresholdCritical or 65535
    })
end
---@param obj Voltage.VoltageUpperThresholdCritical
function TVoltageUpperThresholdCritical:init_from_obj(obj)
    self.VoltageUpperThresholdCritical = obj.VoltageUpperThresholdCritical or 65535
end

function TVoltageUpperThresholdCritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVoltageUpperThresholdCritical.group)
end

TVoltageUpperThresholdCritical.from_obj = TVoltageUpperThresholdCritical_from_obj

TVoltageUpperThresholdCritical.proto_property = {'VoltageUpperThresholdCritical'}

TVoltageUpperThresholdCritical.default = {0}

TVoltageUpperThresholdCritical.struct = {{name = 'VoltageUpperThresholdCritical', is_array = false, struct = nil}}

function TVoltageUpperThresholdCritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VoltageUpperThresholdCritical', self.VoltageUpperThresholdCritical, 'double', true,
        errs, need_convert)

    TVoltageUpperThresholdCritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVoltageUpperThresholdCritical.proto_property, errs, need_convert)
    return self
end

function TVoltageUpperThresholdCritical:unpack(_)
    return self.VoltageUpperThresholdCritical
end

Voltage.VoltageUpperThresholdCritical = TVoltageUpperThresholdCritical

---@class Voltage.VoltageLowerThresholdCritical
---@field VoltageLowerThresholdCritical number
local TVoltageLowerThresholdCritical = {}
TVoltageLowerThresholdCritical.__index = TVoltageLowerThresholdCritical
TVoltageLowerThresholdCritical.group = {}

local function TVoltageLowerThresholdCritical_from_obj(obj)
    return setmetatable(obj, TVoltageLowerThresholdCritical)
end

function TVoltageLowerThresholdCritical.new(VoltageLowerThresholdCritical)
    return TVoltageLowerThresholdCritical_from_obj({
        VoltageLowerThresholdCritical = VoltageLowerThresholdCritical or 65535
    })
end
---@param obj Voltage.VoltageLowerThresholdCritical
function TVoltageLowerThresholdCritical:init_from_obj(obj)
    self.VoltageLowerThresholdCritical = obj.VoltageLowerThresholdCritical or 65535
end

function TVoltageLowerThresholdCritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVoltageLowerThresholdCritical.group)
end

TVoltageLowerThresholdCritical.from_obj = TVoltageLowerThresholdCritical_from_obj

TVoltageLowerThresholdCritical.proto_property = {'VoltageLowerThresholdCritical'}

TVoltageLowerThresholdCritical.default = {0}

TVoltageLowerThresholdCritical.struct = {{name = 'VoltageLowerThresholdCritical', is_array = false, struct = nil}}

function TVoltageLowerThresholdCritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VoltageLowerThresholdCritical', self.VoltageLowerThresholdCritical, 'double', true,
        errs, need_convert)

    TVoltageLowerThresholdCritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVoltageLowerThresholdCritical.proto_property, errs, need_convert)
    return self
end

function TVoltageLowerThresholdCritical:unpack(_)
    return self.VoltageLowerThresholdCritical
end

Voltage.VoltageLowerThresholdCritical = TVoltageLowerThresholdCritical

---@class Voltage.UpperThresholdCritical
---@field UpperThresholdCritical number
local TUpperThresholdCritical = {}
TUpperThresholdCritical.__index = TUpperThresholdCritical
TUpperThresholdCritical.group = {}

local function TUpperThresholdCritical_from_obj(obj)
    return setmetatable(obj, TUpperThresholdCritical)
end

function TUpperThresholdCritical.new(UpperThresholdCritical)
    return TUpperThresholdCritical_from_obj({UpperThresholdCritical = UpperThresholdCritical or 65535})
end
---@param obj Voltage.UpperThresholdCritical
function TUpperThresholdCritical:init_from_obj(obj)
    self.UpperThresholdCritical = obj.UpperThresholdCritical or 65535
end

function TUpperThresholdCritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpperThresholdCritical.group)
end

TUpperThresholdCritical.from_obj = TUpperThresholdCritical_from_obj

TUpperThresholdCritical.proto_property = {'UpperThresholdCritical'}

TUpperThresholdCritical.default = {0}

TUpperThresholdCritical.struct = {{name = 'UpperThresholdCritical', is_array = false, struct = nil}}

function TUpperThresholdCritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UpperThresholdCritical', self.UpperThresholdCritical, 'double', true, errs,
        need_convert)

    TUpperThresholdCritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpperThresholdCritical.proto_property, errs, need_convert)
    return self
end

function TUpperThresholdCritical:unpack(_)
    return self.UpperThresholdCritical
end

Voltage.UpperThresholdCritical = TUpperThresholdCritical

---@class Voltage.LowerThresholdCritical
---@field LowerThresholdCritical number
local TLowerThresholdCritical = {}
TLowerThresholdCritical.__index = TLowerThresholdCritical
TLowerThresholdCritical.group = {}

local function TLowerThresholdCritical_from_obj(obj)
    return setmetatable(obj, TLowerThresholdCritical)
end

function TLowerThresholdCritical.new(LowerThresholdCritical)
    return TLowerThresholdCritical_from_obj({LowerThresholdCritical = LowerThresholdCritical or 65535})
end
---@param obj Voltage.LowerThresholdCritical
function TLowerThresholdCritical:init_from_obj(obj)
    self.LowerThresholdCritical = obj.LowerThresholdCritical or 65535
end

function TLowerThresholdCritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLowerThresholdCritical.group)
end

TLowerThresholdCritical.from_obj = TLowerThresholdCritical_from_obj

TLowerThresholdCritical.proto_property = {'LowerThresholdCritical'}

TLowerThresholdCritical.default = {0}

TLowerThresholdCritical.struct = {{name = 'LowerThresholdCritical', is_array = false, struct = nil}}

function TLowerThresholdCritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LowerThresholdCritical', self.LowerThresholdCritical, 'double', true, errs,
        need_convert)

    TLowerThresholdCritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLowerThresholdCritical.proto_property, errs, need_convert)
    return self
end

function TLowerThresholdCritical:unpack(_)
    return self.LowerThresholdCritical
end

Voltage.LowerThresholdCritical = TLowerThresholdCritical

---@class Voltage.SupplyVoltage
---@field SupplyVoltage number
local TSupplyVoltage = {}
TSupplyVoltage.__index = TSupplyVoltage
TSupplyVoltage.group = {}

local function TSupplyVoltage_from_obj(obj)
    return setmetatable(obj, TSupplyVoltage)
end

function TSupplyVoltage.new(SupplyVoltage)
    return TSupplyVoltage_from_obj({SupplyVoltage = SupplyVoltage or 65535})
end
---@param obj Voltage.SupplyVoltage
function TSupplyVoltage:init_from_obj(obj)
    self.SupplyVoltage = obj.SupplyVoltage or 65535
end

function TSupplyVoltage:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSupplyVoltage.group)
end

TSupplyVoltage.from_obj = TSupplyVoltage_from_obj

TSupplyVoltage.proto_property = {'SupplyVoltage'}

TSupplyVoltage.default = {0}

TSupplyVoltage.struct = {{name = 'SupplyVoltage', is_array = false, struct = nil}}

function TSupplyVoltage:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SupplyVoltage', self.SupplyVoltage, 'double', true, errs, need_convert)

    TSupplyVoltage:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSupplyVoltage.proto_property, errs, need_convert)
    return self
end

function TSupplyVoltage:unpack(_)
    return self.SupplyVoltage
end

Voltage.SupplyVoltage = TSupplyVoltage

Voltage.interface = mdb.register_interface('bmc.kepler.Systems.OpticalModule.Voltage', {
    SupplyVoltage = {'d', {'VOLATILE', 'EMIT_CHANGE'}, true, 65535, false},
    LowerThresholdCritical = {'d', nil, true, 65535, false},
    UpperThresholdCritical = {'d', nil, true, 65535, false},
    VoltageLowerThresholdCritical = {'d', nil, true, 65535, false},
    VoltageUpperThresholdCritical = {'d', nil, true, 65535, false},
    VoltageLowerThresholdWarning = {'d', nil, true, 65535, false},
    VoltageUpperThresholdWarning = {'d', nil, true, 65535, false}
}, {}, {})

return Voltage
