-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Temperature = {}

---@class Temperature.TemperatureUpperThresholdWarning
---@field TemperatureUpperThresholdWarning number
local TTemperatureUpperThresholdWarning = {}
TTemperatureUpperThresholdWarning.__index = TTemperatureUpperThresholdWarning
TTemperatureUpperThresholdWarning.group = {}

local function TTemperatureUpperThresholdWarning_from_obj(obj)
    return setmetatable(obj, TTemperatureUpperThresholdWarning)
end

function TTemperatureUpperThresholdWarning.new(TemperatureUpperThresholdWarning)
    return TTemperatureUpperThresholdWarning_from_obj({
        TemperatureUpperThresholdWarning = TemperatureUpperThresholdWarning or 65535
    })
end
---@param obj Temperature.TemperatureUpperThresholdWarning
function TTemperatureUpperThresholdWarning:init_from_obj(obj)
    self.TemperatureUpperThresholdWarning = obj.TemperatureUpperThresholdWarning or 65535
end

function TTemperatureUpperThresholdWarning:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureUpperThresholdWarning.group)
end

TTemperatureUpperThresholdWarning.from_obj = TTemperatureUpperThresholdWarning_from_obj

TTemperatureUpperThresholdWarning.proto_property = {'TemperatureUpperThresholdWarning'}

TTemperatureUpperThresholdWarning.default = {0}

TTemperatureUpperThresholdWarning.struct = {{name = 'TemperatureUpperThresholdWarning', is_array = false, struct = nil}}

function TTemperatureUpperThresholdWarning:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureUpperThresholdWarning', self.TemperatureUpperThresholdWarning, 'double',
        true, errs, need_convert)

    TTemperatureUpperThresholdWarning:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureUpperThresholdWarning.proto_property, errs, need_convert)
    return self
end

function TTemperatureUpperThresholdWarning:unpack(_)
    return self.TemperatureUpperThresholdWarning
end

Temperature.TemperatureUpperThresholdWarning = TTemperatureUpperThresholdWarning

---@class Temperature.TemperatureLowerThresholdWarning
---@field TemperatureLowerThresholdWarning number
local TTemperatureLowerThresholdWarning = {}
TTemperatureLowerThresholdWarning.__index = TTemperatureLowerThresholdWarning
TTemperatureLowerThresholdWarning.group = {}

local function TTemperatureLowerThresholdWarning_from_obj(obj)
    return setmetatable(obj, TTemperatureLowerThresholdWarning)
end

function TTemperatureLowerThresholdWarning.new(TemperatureLowerThresholdWarning)
    return TTemperatureLowerThresholdWarning_from_obj({
        TemperatureLowerThresholdWarning = TemperatureLowerThresholdWarning or 65535
    })
end
---@param obj Temperature.TemperatureLowerThresholdWarning
function TTemperatureLowerThresholdWarning:init_from_obj(obj)
    self.TemperatureLowerThresholdWarning = obj.TemperatureLowerThresholdWarning or 65535
end

function TTemperatureLowerThresholdWarning:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureLowerThresholdWarning.group)
end

TTemperatureLowerThresholdWarning.from_obj = TTemperatureLowerThresholdWarning_from_obj

TTemperatureLowerThresholdWarning.proto_property = {'TemperatureLowerThresholdWarning'}

TTemperatureLowerThresholdWarning.default = {0}

TTemperatureLowerThresholdWarning.struct = {{name = 'TemperatureLowerThresholdWarning', is_array = false, struct = nil}}

function TTemperatureLowerThresholdWarning:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureLowerThresholdWarning', self.TemperatureLowerThresholdWarning, 'double',
        true, errs, need_convert)

    TTemperatureLowerThresholdWarning:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureLowerThresholdWarning.proto_property, errs, need_convert)
    return self
end

function TTemperatureLowerThresholdWarning:unpack(_)
    return self.TemperatureLowerThresholdWarning
end

Temperature.TemperatureLowerThresholdWarning = TTemperatureLowerThresholdWarning

---@class Temperature.TemperatureUpperThresholdCritical
---@field TemperatureUpperThresholdCritical number
local TTemperatureUpperThresholdCritical = {}
TTemperatureUpperThresholdCritical.__index = TTemperatureUpperThresholdCritical
TTemperatureUpperThresholdCritical.group = {}

local function TTemperatureUpperThresholdCritical_from_obj(obj)
    return setmetatable(obj, TTemperatureUpperThresholdCritical)
end

function TTemperatureUpperThresholdCritical.new(TemperatureUpperThresholdCritical)
    return TTemperatureUpperThresholdCritical_from_obj({
        TemperatureUpperThresholdCritical = TemperatureUpperThresholdCritical or 65535
    })
end
---@param obj Temperature.TemperatureUpperThresholdCritical
function TTemperatureUpperThresholdCritical:init_from_obj(obj)
    self.TemperatureUpperThresholdCritical = obj.TemperatureUpperThresholdCritical or 65535
end

function TTemperatureUpperThresholdCritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureUpperThresholdCritical.group)
end

TTemperatureUpperThresholdCritical.from_obj = TTemperatureUpperThresholdCritical_from_obj

TTemperatureUpperThresholdCritical.proto_property = {'TemperatureUpperThresholdCritical'}

TTemperatureUpperThresholdCritical.default = {0}

TTemperatureUpperThresholdCritical.struct = {
    {name = 'TemperatureUpperThresholdCritical', is_array = false, struct = nil}
}

function TTemperatureUpperThresholdCritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureUpperThresholdCritical', self.TemperatureUpperThresholdCritical, 'double',
        true, errs, need_convert)

    TTemperatureUpperThresholdCritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureUpperThresholdCritical.proto_property, errs, need_convert)
    return self
end

function TTemperatureUpperThresholdCritical:unpack(_)
    return self.TemperatureUpperThresholdCritical
end

Temperature.TemperatureUpperThresholdCritical = TTemperatureUpperThresholdCritical

---@class Temperature.TemperatureLowerThresholdCritical
---@field TemperatureLowerThresholdCritical number
local TTemperatureLowerThresholdCritical = {}
TTemperatureLowerThresholdCritical.__index = TTemperatureLowerThresholdCritical
TTemperatureLowerThresholdCritical.group = {}

local function TTemperatureLowerThresholdCritical_from_obj(obj)
    return setmetatable(obj, TTemperatureLowerThresholdCritical)
end

function TTemperatureLowerThresholdCritical.new(TemperatureLowerThresholdCritical)
    return TTemperatureLowerThresholdCritical_from_obj({
        TemperatureLowerThresholdCritical = TemperatureLowerThresholdCritical or 65535
    })
end
---@param obj Temperature.TemperatureLowerThresholdCritical
function TTemperatureLowerThresholdCritical:init_from_obj(obj)
    self.TemperatureLowerThresholdCritical = obj.TemperatureLowerThresholdCritical or 65535
end

function TTemperatureLowerThresholdCritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTemperatureLowerThresholdCritical.group)
end

TTemperatureLowerThresholdCritical.from_obj = TTemperatureLowerThresholdCritical_from_obj

TTemperatureLowerThresholdCritical.proto_property = {'TemperatureLowerThresholdCritical'}

TTemperatureLowerThresholdCritical.default = {0}

TTemperatureLowerThresholdCritical.struct = {
    {name = 'TemperatureLowerThresholdCritical', is_array = false, struct = nil}
}

function TTemperatureLowerThresholdCritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TemperatureLowerThresholdCritical', self.TemperatureLowerThresholdCritical, 'double',
        true, errs, need_convert)

    TTemperatureLowerThresholdCritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTemperatureLowerThresholdCritical.proto_property, errs, need_convert)
    return self
end

function TTemperatureLowerThresholdCritical:unpack(_)
    return self.TemperatureLowerThresholdCritical
end

Temperature.TemperatureLowerThresholdCritical = TTemperatureLowerThresholdCritical

---@class Temperature.UpperThresholdCritical
---@field UpperThresholdCritical number
local TUpperThresholdCritical = {}
TUpperThresholdCritical.__index = TUpperThresholdCritical
TUpperThresholdCritical.group = {}

local function TUpperThresholdCritical_from_obj(obj)
    return setmetatable(obj, TUpperThresholdCritical)
end

function TUpperThresholdCritical.new(UpperThresholdCritical)
    return TUpperThresholdCritical_from_obj({UpperThresholdCritical = UpperThresholdCritical or 65535})
end
---@param obj Temperature.UpperThresholdCritical
function TUpperThresholdCritical:init_from_obj(obj)
    self.UpperThresholdCritical = obj.UpperThresholdCritical or 65535
end

function TUpperThresholdCritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpperThresholdCritical.group)
end

TUpperThresholdCritical.from_obj = TUpperThresholdCritical_from_obj

TUpperThresholdCritical.proto_property = {'UpperThresholdCritical'}

TUpperThresholdCritical.default = {0}

TUpperThresholdCritical.struct = {{name = 'UpperThresholdCritical', is_array = false, struct = nil}}

function TUpperThresholdCritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UpperThresholdCritical', self.UpperThresholdCritical, 'double', true, errs,
        need_convert)

    TUpperThresholdCritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpperThresholdCritical.proto_property, errs, need_convert)
    return self
end

function TUpperThresholdCritical:unpack(_)
    return self.UpperThresholdCritical
end

Temperature.UpperThresholdCritical = TUpperThresholdCritical

---@class Temperature.LowerThresholdCritical
---@field LowerThresholdCritical number
local TLowerThresholdCritical = {}
TLowerThresholdCritical.__index = TLowerThresholdCritical
TLowerThresholdCritical.group = {}

local function TLowerThresholdCritical_from_obj(obj)
    return setmetatable(obj, TLowerThresholdCritical)
end

function TLowerThresholdCritical.new(LowerThresholdCritical)
    return TLowerThresholdCritical_from_obj({LowerThresholdCritical = LowerThresholdCritical or 65535})
end
---@param obj Temperature.LowerThresholdCritical
function TLowerThresholdCritical:init_from_obj(obj)
    self.LowerThresholdCritical = obj.LowerThresholdCritical or 65535
end

function TLowerThresholdCritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLowerThresholdCritical.group)
end

TLowerThresholdCritical.from_obj = TLowerThresholdCritical_from_obj

TLowerThresholdCritical.proto_property = {'LowerThresholdCritical'}

TLowerThresholdCritical.default = {0}

TLowerThresholdCritical.struct = {{name = 'LowerThresholdCritical', is_array = false, struct = nil}}

function TLowerThresholdCritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LowerThresholdCritical', self.LowerThresholdCritical, 'double', true, errs,
        need_convert)

    TLowerThresholdCritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLowerThresholdCritical.proto_property, errs, need_convert)
    return self
end

function TLowerThresholdCritical:unpack(_)
    return self.LowerThresholdCritical
end

Temperature.LowerThresholdCritical = TLowerThresholdCritical

---@class Temperature.ReadingCelsius
---@field ReadingCelsius number
local TReadingCelsius = {}
TReadingCelsius.__index = TReadingCelsius
TReadingCelsius.group = {}

local function TReadingCelsius_from_obj(obj)
    return setmetatable(obj, TReadingCelsius)
end

function TReadingCelsius.new(ReadingCelsius)
    return TReadingCelsius_from_obj({ReadingCelsius = ReadingCelsius or 65535})
end
---@param obj Temperature.ReadingCelsius
function TReadingCelsius:init_from_obj(obj)
    self.ReadingCelsius = obj.ReadingCelsius or 65535
end

function TReadingCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TReadingCelsius.group)
end

TReadingCelsius.from_obj = TReadingCelsius_from_obj

TReadingCelsius.proto_property = {'ReadingCelsius'}

TReadingCelsius.default = {0}

TReadingCelsius.struct = {{name = 'ReadingCelsius', is_array = false, struct = nil}}

function TReadingCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReadingCelsius', self.ReadingCelsius, 'double', true, errs, need_convert)

    TReadingCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TReadingCelsius.proto_property, errs, need_convert)
    return self
end

function TReadingCelsius:unpack(_)
    return self.ReadingCelsius
end

Temperature.ReadingCelsius = TReadingCelsius

Temperature.interface = mdb.register_interface('bmc.kepler.Systems.OpticalModule.Temperature', {
    ReadingCelsius = {'d', {'VOLATILE', 'EMIT_CHANGE'}, true, 65535, false},
    LowerThresholdCritical = {'d', nil, true, 65535, false},
    UpperThresholdCritical = {'d', nil, true, 65535, false},
    TemperatureLowerThresholdCritical = {'d', nil, true, 65535, false},
    TemperatureUpperThresholdCritical = {'d', nil, true, 65535, false},
    TemperatureLowerThresholdWarning = {'d', nil, true, 65535, false},
    TemperatureUpperThresholdWarning = {'d', nil, true, 65535, false}
}, {}, {})

return Temperature
