-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local PCIe = {}

---@class PCIe.RoutingTableReady
---@field RoutingTableReady boolean
local TRoutingTableReady = {}
TRoutingTableReady.__index = TRoutingTableReady
TRoutingTableReady.group = {}

local function TRoutingTableReady_from_obj(obj)
    return setmetatable(obj, TRoutingTableReady)
end

function TRoutingTableReady.new(RoutingTableReady)
    return TRoutingTableReady_from_obj({RoutingTableReady = RoutingTableReady})
end
---@param obj PCIe.RoutingTableReady
function TRoutingTableReady:init_from_obj(obj)
    self.RoutingTableReady = obj.RoutingTableReady
end

function TRoutingTableReady:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRoutingTableReady.group)
end

TRoutingTableReady.from_obj = TRoutingTableReady_from_obj

TRoutingTableReady.proto_property = {'RoutingTableReady'}

TRoutingTableReady.default = {false}

TRoutingTableReady.struct = {{name = 'RoutingTableReady', is_array = false, struct = nil}}

function TRoutingTableReady:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RoutingTableReady', self.RoutingTableReady, 'bool', true, errs, need_convert)

    TRoutingTableReady:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRoutingTableReady.proto_property, errs, need_convert)
    return self
end

function TRoutingTableReady:unpack(_)
    return self.RoutingTableReady
end

PCIe.RoutingTableReady = TRoutingTableReady

---@class PCIe.DiscoverFinished
---@field DiscoverFinished boolean
local TDiscoverFinished = {}
TDiscoverFinished.__index = TDiscoverFinished
TDiscoverFinished.group = {}

local function TDiscoverFinished_from_obj(obj)
    return setmetatable(obj, TDiscoverFinished)
end

function TDiscoverFinished.new(DiscoverFinished)
    return TDiscoverFinished_from_obj({DiscoverFinished = DiscoverFinished})
end
---@param obj PCIe.DiscoverFinished
function TDiscoverFinished:init_from_obj(obj)
    self.DiscoverFinished = obj.DiscoverFinished
end

function TDiscoverFinished:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDiscoverFinished.group)
end

TDiscoverFinished.from_obj = TDiscoverFinished_from_obj

TDiscoverFinished.proto_property = {'DiscoverFinished'}

TDiscoverFinished.default = {false}

TDiscoverFinished.struct = {{name = 'DiscoverFinished', is_array = false, struct = nil}}

function TDiscoverFinished:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DiscoverFinished', self.DiscoverFinished, 'bool', true, errs, need_convert)

    TDiscoverFinished:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDiscoverFinished.proto_property, errs, need_convert)
    return self
end

function TDiscoverFinished:unpack(_)
    return self.DiscoverFinished
end

PCIe.DiscoverFinished = TDiscoverFinished

---@class PCIe.BmcPhyAddr
---@field BmcPhyAddr integer
local TBmcPhyAddr = {}
TBmcPhyAddr.__index = TBmcPhyAddr
TBmcPhyAddr.group = {}

local function TBmcPhyAddr_from_obj(obj)
    return setmetatable(obj, TBmcPhyAddr)
end

function TBmcPhyAddr.new(BmcPhyAddr)
    return TBmcPhyAddr_from_obj({BmcPhyAddr = BmcPhyAddr})
end
---@param obj PCIe.BmcPhyAddr
function TBmcPhyAddr:init_from_obj(obj)
    self.BmcPhyAddr = obj.BmcPhyAddr
end

function TBmcPhyAddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBmcPhyAddr.group)
end

TBmcPhyAddr.from_obj = TBmcPhyAddr_from_obj

TBmcPhyAddr.proto_property = {'BmcPhyAddr'}

TBmcPhyAddr.default = {0}

TBmcPhyAddr.struct = {{name = 'BmcPhyAddr', is_array = false, struct = nil}}

function TBmcPhyAddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BmcPhyAddr', self.BmcPhyAddr, 'uint16', true, errs, need_convert)

    TBmcPhyAddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBmcPhyAddr.proto_property, errs, need_convert)
    return self
end

function TBmcPhyAddr:unpack(_)
    return self.BmcPhyAddr
end

PCIe.BmcPhyAddr = TBmcPhyAddr

---@class PCIe.BmcEid
---@field BmcEid integer
local TBmcEid = {}
TBmcEid.__index = TBmcEid
TBmcEid.group = {}

local function TBmcEid_from_obj(obj)
    return setmetatable(obj, TBmcEid)
end

function TBmcEid.new(BmcEid)
    return TBmcEid_from_obj({BmcEid = BmcEid})
end
---@param obj PCIe.BmcEid
function TBmcEid:init_from_obj(obj)
    self.BmcEid = obj.BmcEid
end

function TBmcEid:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBmcEid.group)
end

TBmcEid.from_obj = TBmcEid_from_obj

TBmcEid.proto_property = {'BmcEid'}

TBmcEid.default = {0}

TBmcEid.struct = {{name = 'BmcEid', is_array = false, struct = nil}}

function TBmcEid:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BmcEid', self.BmcEid, 'uint8', true, errs, need_convert)

    TBmcEid:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBmcEid.proto_property, errs, need_convert)
    return self
end

function TBmcEid:unpack(_)
    return self.BmcEid
end

PCIe.BmcEid = TBmcEid

---@class PCIe.OwnerPhyAddr
---@field OwnerPhyAddr integer
local TOwnerPhyAddr = {}
TOwnerPhyAddr.__index = TOwnerPhyAddr
TOwnerPhyAddr.group = {}

local function TOwnerPhyAddr_from_obj(obj)
    return setmetatable(obj, TOwnerPhyAddr)
end

function TOwnerPhyAddr.new(OwnerPhyAddr)
    return TOwnerPhyAddr_from_obj({OwnerPhyAddr = OwnerPhyAddr})
end
---@param obj PCIe.OwnerPhyAddr
function TOwnerPhyAddr:init_from_obj(obj)
    self.OwnerPhyAddr = obj.OwnerPhyAddr
end

function TOwnerPhyAddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOwnerPhyAddr.group)
end

TOwnerPhyAddr.from_obj = TOwnerPhyAddr_from_obj

TOwnerPhyAddr.proto_property = {'OwnerPhyAddr'}

TOwnerPhyAddr.default = {0}

TOwnerPhyAddr.struct = {{name = 'OwnerPhyAddr', is_array = false, struct = nil}}

function TOwnerPhyAddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OwnerPhyAddr', self.OwnerPhyAddr, 'uint16', true, errs, need_convert)

    TOwnerPhyAddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOwnerPhyAddr.proto_property, errs, need_convert)
    return self
end

function TOwnerPhyAddr:unpack(_)
    return self.OwnerPhyAddr
end

PCIe.OwnerPhyAddr = TOwnerPhyAddr

---@class PCIe.OwnerEid
---@field OwnerEid integer
local TOwnerEid = {}
TOwnerEid.__index = TOwnerEid
TOwnerEid.group = {}

local function TOwnerEid_from_obj(obj)
    return setmetatable(obj, TOwnerEid)
end

function TOwnerEid.new(OwnerEid)
    return TOwnerEid_from_obj({OwnerEid = OwnerEid})
end
---@param obj PCIe.OwnerEid
function TOwnerEid:init_from_obj(obj)
    self.OwnerEid = obj.OwnerEid
end

function TOwnerEid:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOwnerEid.group)
end

TOwnerEid.from_obj = TOwnerEid_from_obj

TOwnerEid.proto_property = {'OwnerEid'}

TOwnerEid.default = {0}

TOwnerEid.struct = {{name = 'OwnerEid', is_array = false, struct = nil}}

function TOwnerEid:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OwnerEid', self.OwnerEid, 'uint8', true, errs, need_convert)

    TOwnerEid:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOwnerEid.proto_property, errs, need_convert)
    return self
end

function TOwnerEid:unpack(_)
    return self.OwnerEid
end

PCIe.OwnerEid = TOwnerEid

PCIe.interface = mdb.register_interface('bmc.kepler.Systems.Mctp.MctpBinding.PCIe', {
    OwnerEid = {'y', nil, true, nil, false},
    OwnerPhyAddr = {'q', nil, true, nil, false},
    BmcEid = {'y', nil, true, nil, false},
    BmcPhyAddr = {'q', nil, true, nil, false},
    DiscoverFinished = {'b', nil, true, nil, false},
    RoutingTableReady = {'b', nil, true, nil, false}
}, {}, {})

return PCIe
