-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local NetworkPort = {}

---@class NetworkPort.NodeId
---@field NodeId string
local TNodeId = {}
TNodeId.__index = TNodeId
TNodeId.group = {}

local function TNodeId_from_obj(obj)
    return setmetatable(obj, TNodeId)
end

function TNodeId.new(NodeId)
    return TNodeId_from_obj({NodeId = NodeId})
end
---@param obj NetworkPort.NodeId
function TNodeId:init_from_obj(obj)
    self.NodeId = obj.NodeId
end

function TNodeId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNodeId.group)
end

TNodeId.from_obj = TNodeId_from_obj

TNodeId.proto_property = {'NodeId'}

TNodeId.default = {''}

TNodeId.struct = {{name = 'NodeId', is_array = false, struct = nil}}

function TNodeId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NodeId', self.NodeId, 'string', true, errs, need_convert)

    TNodeId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNodeId.proto_property, errs, need_convert)
    return self
end

function TNodeId:unpack(_)
    return self.NodeId
end

NetworkPort.NodeId = TNodeId

---@class NetworkPort.WorkloadType
---@field WorkloadType integer
local TWorkloadType = {}
TWorkloadType.__index = TWorkloadType
TWorkloadType.group = {}

local function TWorkloadType_from_obj(obj)
    return setmetatable(obj, TWorkloadType)
end

function TWorkloadType.new(WorkloadType)
    return TWorkloadType_from_obj({WorkloadType = WorkloadType})
end
---@param obj NetworkPort.WorkloadType
function TWorkloadType:init_from_obj(obj)
    self.WorkloadType = obj.WorkloadType
end

function TWorkloadType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWorkloadType.group)
end

TWorkloadType.from_obj = TWorkloadType_from_obj

TWorkloadType.proto_property = {'WorkloadType'}

TWorkloadType.default = {0}

TWorkloadType.struct = {{name = 'WorkloadType', is_array = false, struct = nil}}

function TWorkloadType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'WorkloadType', self.WorkloadType, 'uint8', true, errs, need_convert)

    TWorkloadType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWorkloadType.proto_property, errs, need_convert)
    return self
end

function TWorkloadType:unpack(_)
    return self.WorkloadType
end

NetworkPort.WorkloadType = TWorkloadType

---@class NetworkPort.UUID
---@field UUID string
local TUUID = {}
TUUID.__index = TUUID
TUUID.group = {}

local function TUUID_from_obj(obj)
    return setmetatable(obj, TUUID)
end

function TUUID.new(UUID)
    return TUUID_from_obj({UUID = UUID})
end
---@param obj NetworkPort.UUID
function TUUID:init_from_obj(obj)
    self.UUID = obj.UUID
end

function TUUID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUUID.group)
end

TUUID.from_obj = TUUID_from_obj

TUUID.proto_property = {'UUID'}

TUUID.default = {''}

TUUID.struct = {{name = 'UUID', is_array = false, struct = nil}}

function TUUID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UUID', self.UUID, 'string', true, errs, need_convert)

    TUUID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUUID.proto_property, errs, need_convert)
    return self
end

function TUUID:unpack(_)
    return self.UUID
end

NetworkPort.UUID = TUUID

---@class NetworkPort.LinkMonitorPeriodMS
---@field LinkMonitorPeriodMS integer
local TLinkMonitorPeriodMS = {}
TLinkMonitorPeriodMS.__index = TLinkMonitorPeriodMS
TLinkMonitorPeriodMS.group = {}

local function TLinkMonitorPeriodMS_from_obj(obj)
    return setmetatable(obj, TLinkMonitorPeriodMS)
end

function TLinkMonitorPeriodMS.new(LinkMonitorPeriodMS)
    return TLinkMonitorPeriodMS_from_obj({LinkMonitorPeriodMS = LinkMonitorPeriodMS})
end
---@param obj NetworkPort.LinkMonitorPeriodMS
function TLinkMonitorPeriodMS:init_from_obj(obj)
    self.LinkMonitorPeriodMS = obj.LinkMonitorPeriodMS
end

function TLinkMonitorPeriodMS:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkMonitorPeriodMS.group)
end

TLinkMonitorPeriodMS.from_obj = TLinkMonitorPeriodMS_from_obj

TLinkMonitorPeriodMS.proto_property = {'LinkMonitorPeriodMS'}

TLinkMonitorPeriodMS.default = {0}

TLinkMonitorPeriodMS.struct = {{name = 'LinkMonitorPeriodMS', is_array = false, struct = nil}}

function TLinkMonitorPeriodMS:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkMonitorPeriodMS', self.LinkMonitorPeriodMS, 'uint32', true, errs, need_convert)

    TLinkMonitorPeriodMS:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkMonitorPeriodMS.proto_property, errs, need_convert)
    return self
end

function TLinkMonitorPeriodMS:unpack(_)
    return self.LinkMonitorPeriodMS
end

NetworkPort.LinkMonitorPeriodMS = TLinkMonitorPeriodMS

---@class NetworkPort.NetworkAdapterId
---@field NetworkAdapterId string
local TNetworkAdapterId = {}
TNetworkAdapterId.__index = TNetworkAdapterId
TNetworkAdapterId.group = {}

local function TNetworkAdapterId_from_obj(obj)
    return setmetatable(obj, TNetworkAdapterId)
end

function TNetworkAdapterId.new(NetworkAdapterId)
    return TNetworkAdapterId_from_obj({NetworkAdapterId = NetworkAdapterId})
end
---@param obj NetworkPort.NetworkAdapterId
function TNetworkAdapterId:init_from_obj(obj)
    self.NetworkAdapterId = obj.NetworkAdapterId
end

function TNetworkAdapterId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNetworkAdapterId.group)
end

TNetworkAdapterId.from_obj = TNetworkAdapterId_from_obj

TNetworkAdapterId.proto_property = {'NetworkAdapterId'}

TNetworkAdapterId.default = {''}

TNetworkAdapterId.struct = {{name = 'NetworkAdapterId', is_array = false, struct = nil}}

function TNetworkAdapterId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'NetworkAdapterId', self.NetworkAdapterId, 'string', true, errs, need_convert)

    TNetworkAdapterId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNetworkAdapterId.proto_property, errs, need_convert)
    return self
end

function TNetworkAdapterId:unpack(_)
    return self.NetworkAdapterId
end

NetworkPort.NetworkAdapterId = TNetworkAdapterId

---@class NetworkPort.SupportedLinkCapability
---@field SupportedLinkCapability string
local TSupportedLinkCapability = {}
TSupportedLinkCapability.__index = TSupportedLinkCapability
TSupportedLinkCapability.group = {}

local function TSupportedLinkCapability_from_obj(obj)
    return setmetatable(obj, TSupportedLinkCapability)
end

function TSupportedLinkCapability.new(SupportedLinkCapability)
    return TSupportedLinkCapability_from_obj({SupportedLinkCapability = SupportedLinkCapability})
end
---@param obj NetworkPort.SupportedLinkCapability
function TSupportedLinkCapability:init_from_obj(obj)
    self.SupportedLinkCapability = obj.SupportedLinkCapability
end

function TSupportedLinkCapability:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSupportedLinkCapability.group)
end

TSupportedLinkCapability.from_obj = TSupportedLinkCapability_from_obj

TSupportedLinkCapability.proto_property = {'SupportedLinkCapability'}

TSupportedLinkCapability.default = {''}

TSupportedLinkCapability.struct = {{name = 'SupportedLinkCapability', is_array = false, struct = nil}}

function TSupportedLinkCapability:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SupportedLinkCapability', self.SupportedLinkCapability, 'string', true, errs,
        need_convert)

    TSupportedLinkCapability:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSupportedLinkCapability.proto_property, errs, need_convert)
    return self
end

function TSupportedLinkCapability:unpack(_)
    return self.SupportedLinkCapability
end

NetworkPort.SupportedLinkCapability = TSupportedLinkCapability

---@class NetworkPort.LLDPEnabled
---@field LLDPEnabled boolean
local TLLDPEnabled = {}
TLLDPEnabled.__index = TLLDPEnabled
TLLDPEnabled.group = {}

local function TLLDPEnabled_from_obj(obj)
    return setmetatable(obj, TLLDPEnabled)
end

function TLLDPEnabled.new(LLDPEnabled)
    return TLLDPEnabled_from_obj({LLDPEnabled = LLDPEnabled})
end
---@param obj NetworkPort.LLDPEnabled
function TLLDPEnabled:init_from_obj(obj)
    self.LLDPEnabled = obj.LLDPEnabled
end

function TLLDPEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLLDPEnabled.group)
end

TLLDPEnabled.from_obj = TLLDPEnabled_from_obj

TLLDPEnabled.proto_property = {'LLDPEnabled'}

TLLDPEnabled.default = {false}

TLLDPEnabled.struct = {{name = 'LLDPEnabled', is_array = false, struct = nil}}

function TLLDPEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LLDPEnabled', self.LLDPEnabled, 'bool', false, errs, need_convert)

    TLLDPEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLLDPEnabled.proto_property, errs, need_convert)
    return self
end

function TLLDPEnabled:unpack(_)
    return self.LLDPEnabled
end

NetworkPort.LLDPEnabled = TLLDPEnabled

---@class NetworkPort.DriverVersion
---@field DriverVersion string
local TDriverVersion = {}
TDriverVersion.__index = TDriverVersion
TDriverVersion.group = {}

local function TDriverVersion_from_obj(obj)
    return setmetatable(obj, TDriverVersion)
end

function TDriverVersion.new(DriverVersion)
    return TDriverVersion_from_obj({DriverVersion = DriverVersion})
end
---@param obj NetworkPort.DriverVersion
function TDriverVersion:init_from_obj(obj)
    self.DriverVersion = obj.DriverVersion
end

function TDriverVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDriverVersion.group)
end

TDriverVersion.from_obj = TDriverVersion_from_obj

TDriverVersion.proto_property = {'DriverVersion'}

TDriverVersion.default = {''}

TDriverVersion.struct = {{name = 'DriverVersion', is_array = false, struct = nil}}

function TDriverVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DriverVersion', self.DriverVersion, 'string', true, errs, need_convert)

    TDriverVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDriverVersion.proto_property, errs, need_convert)
    return self
end

function TDriverVersion:unpack(_)
    return self.DriverVersion
end

NetworkPort.DriverVersion = TDriverVersion

---@class NetworkPort.DriverName
---@field DriverName string
local TDriverName = {}
TDriverName.__index = TDriverName
TDriverName.group = {}

local function TDriverName_from_obj(obj)
    return setmetatable(obj, TDriverName)
end

function TDriverName.new(DriverName)
    return TDriverName_from_obj({DriverName = DriverName})
end
---@param obj NetworkPort.DriverName
function TDriverName:init_from_obj(obj)
    self.DriverName = obj.DriverName
end

function TDriverName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDriverName.group)
end

TDriverName.from_obj = TDriverName_from_obj

TDriverName.proto_property = {'DriverName'}

TDriverName.default = {''}

TDriverName.struct = {{name = 'DriverName', is_array = false, struct = nil}}

function TDriverName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DriverName', self.DriverName, 'string', true, errs, need_convert)

    TDriverName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDriverName.proto_property, errs, need_convert)
    return self
end

function TDriverName:unpack(_)
    return self.DriverName
end

NetworkPort.DriverName = TDriverName

---@class NetworkPort.FirmwareVersion
---@field FirmwareVersion string
local TFirmwareVersion = {}
TFirmwareVersion.__index = TFirmwareVersion
TFirmwareVersion.group = {}

local function TFirmwareVersion_from_obj(obj)
    return setmetatable(obj, TFirmwareVersion)
end

function TFirmwareVersion.new(FirmwareVersion)
    return TFirmwareVersion_from_obj({FirmwareVersion = FirmwareVersion})
end
---@param obj NetworkPort.FirmwareVersion
function TFirmwareVersion:init_from_obj(obj)
    self.FirmwareVersion = obj.FirmwareVersion
end

function TFirmwareVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirmwareVersion.group)
end

TFirmwareVersion.from_obj = TFirmwareVersion_from_obj

TFirmwareVersion.proto_property = {'FirmwareVersion'}

TFirmwareVersion.default = {''}

TFirmwareVersion.struct = {{name = 'FirmwareVersion', is_array = false, struct = nil}}

function TFirmwareVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareVersion', self.FirmwareVersion, 'string', true, errs, need_convert)

    TFirmwareVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFirmwareVersion.proto_property, errs, need_convert)
    return self
end

function TFirmwareVersion:unpack(_)
    return self.FirmwareVersion
end

NetworkPort.FirmwareVersion = TFirmwareVersion

---@class NetworkPort.AutoSpeedNegotiation
---@field AutoSpeedNegotiation boolean
local TAutoSpeedNegotiation = {}
TAutoSpeedNegotiation.__index = TAutoSpeedNegotiation
TAutoSpeedNegotiation.group = {}

local function TAutoSpeedNegotiation_from_obj(obj)
    return setmetatable(obj, TAutoSpeedNegotiation)
end

function TAutoSpeedNegotiation.new(AutoSpeedNegotiation)
    return TAutoSpeedNegotiation_from_obj({AutoSpeedNegotiation = AutoSpeedNegotiation})
end
---@param obj NetworkPort.AutoSpeedNegotiation
function TAutoSpeedNegotiation:init_from_obj(obj)
    self.AutoSpeedNegotiation = obj.AutoSpeedNegotiation
end

function TAutoSpeedNegotiation:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAutoSpeedNegotiation.group)
end

TAutoSpeedNegotiation.from_obj = TAutoSpeedNegotiation_from_obj

TAutoSpeedNegotiation.proto_property = {'AutoSpeedNegotiation'}

TAutoSpeedNegotiation.default = {false}

TAutoSpeedNegotiation.struct = {{name = 'AutoSpeedNegotiation', is_array = false, struct = nil}}

function TAutoSpeedNegotiation:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AutoSpeedNegotiation', self.AutoSpeedNegotiation, 'bool', true, errs, need_convert)

    TAutoSpeedNegotiation:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAutoSpeedNegotiation.proto_property, errs, need_convert)
    return self
end

function TAutoSpeedNegotiation:unpack(_)
    return self.AutoSpeedNegotiation
end

NetworkPort.AutoSpeedNegotiation = TAutoSpeedNegotiation

---@class NetworkPort.FullDuplex
---@field FullDuplex boolean
local TFullDuplex = {}
TFullDuplex.__index = TFullDuplex
TFullDuplex.group = {}

local function TFullDuplex_from_obj(obj)
    return setmetatable(obj, TFullDuplex)
end

function TFullDuplex.new(FullDuplex)
    return TFullDuplex_from_obj({FullDuplex = FullDuplex})
end
---@param obj NetworkPort.FullDuplex
function TFullDuplex:init_from_obj(obj)
    self.FullDuplex = obj.FullDuplex
end

function TFullDuplex:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFullDuplex.group)
end

TFullDuplex.from_obj = TFullDuplex_from_obj

TFullDuplex.proto_property = {'FullDuplex'}

TFullDuplex.default = {false}

TFullDuplex.struct = {{name = 'FullDuplex', is_array = false, struct = nil}}

function TFullDuplex:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FullDuplex', self.FullDuplex, 'bool', true, errs, need_convert)

    TFullDuplex:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFullDuplex.proto_property, errs, need_convert)
    return self
end

function TFullDuplex:unpack(_)
    return self.FullDuplex
end

NetworkPort.FullDuplex = TFullDuplex

---@class NetworkPort.SpeedMbps
---@field SpeedMbps integer
local TSpeedMbps = {}
TSpeedMbps.__index = TSpeedMbps
TSpeedMbps.group = {}

local function TSpeedMbps_from_obj(obj)
    return setmetatable(obj, TSpeedMbps)
end

function TSpeedMbps.new(SpeedMbps)
    return TSpeedMbps_from_obj({SpeedMbps = SpeedMbps or 4294967295})
end
---@param obj NetworkPort.SpeedMbps
function TSpeedMbps:init_from_obj(obj)
    self.SpeedMbps = obj.SpeedMbps or 4294967295
end

function TSpeedMbps:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSpeedMbps.group)
end

TSpeedMbps.from_obj = TSpeedMbps_from_obj

TSpeedMbps.proto_property = {'SpeedMbps'}

TSpeedMbps.default = {0}

TSpeedMbps.struct = {{name = 'SpeedMbps', is_array = false, struct = nil}}

function TSpeedMbps:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SpeedMbps', self.SpeedMbps, 'uint32', true, errs, need_convert)

    TSpeedMbps:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSpeedMbps.proto_property, errs, need_convert)
    return self
end

function TSpeedMbps:unpack(_)
    return self.SpeedMbps
end

NetworkPort.SpeedMbps = TSpeedMbps

---@class NetworkPort.MediumType
---@field MediumType string
local TMediumType = {}
TMediumType.__index = TMediumType
TMediumType.group = {}

local function TMediumType_from_obj(obj)
    return setmetatable(obj, TMediumType)
end

function TMediumType.new(MediumType)
    return TMediumType_from_obj({MediumType = MediumType or [=[Copper]=]})
end
---@param obj NetworkPort.MediumType
function TMediumType:init_from_obj(obj)
    self.MediumType = obj.MediumType or [=[Copper]=]
end

function TMediumType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMediumType.group)
end

TMediumType.from_obj = TMediumType_from_obj

TMediumType.proto_property = {'MediumType'}

TMediumType.default = {''}

TMediumType.struct = {{name = 'MediumType', is_array = false, struct = nil}}

function TMediumType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MediumType', self.MediumType, 'string', true, errs, need_convert)

    if self.MediumType ~= nil then
        validate.Enum(prefix .. 'MediumType', self.MediumType, '', {'Copper', 'FiberOptic'}, errs, need_convert)
    end

    TMediumType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMediumType.proto_property, errs, need_convert)
    return self
end

function TMediumType:unpack(_)
    return self.MediumType
end

NetworkPort.MediumType = TMediumType

---@class NetworkPort.NetDevFuncType
---@field NetDevFuncType integer
local TNetDevFuncType = {}
TNetDevFuncType.__index = TNetDevFuncType
TNetDevFuncType.group = {}

local function TNetDevFuncType_from_obj(obj)
    return setmetatable(obj, TNetDevFuncType)
end

function TNetDevFuncType.new(NetDevFuncType)
    return TNetDevFuncType_from_obj({NetDevFuncType = NetDevFuncType or 1})
end
---@param obj NetworkPort.NetDevFuncType
function TNetDevFuncType:init_from_obj(obj)
    self.NetDevFuncType = obj.NetDevFuncType or 1
end

function TNetDevFuncType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNetDevFuncType.group)
end

TNetDevFuncType.from_obj = TNetDevFuncType_from_obj

TNetDevFuncType.proto_property = {'NetDevFuncType'}

TNetDevFuncType.default = {0}

TNetDevFuncType.struct = {{name = 'NetDevFuncType', is_array = false, struct = nil}}

function TNetDevFuncType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NetDevFuncType', self.NetDevFuncType, 'uint8', true, errs, need_convert)

    TNetDevFuncType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNetDevFuncType.proto_property, errs, need_convert)
    return self
end

function TNetDevFuncType:unpack(_)
    return self.NetDevFuncType
end

NetworkPort.NetDevFuncType = TNetDevFuncType

---@class NetworkPort.AutoConnectOnBoot
---@field AutoConnectOnBoot boolean
local TAutoConnectOnBoot = {}
TAutoConnectOnBoot.__index = TAutoConnectOnBoot
TAutoConnectOnBoot.group = {}

local function TAutoConnectOnBoot_from_obj(obj)
    return setmetatable(obj, TAutoConnectOnBoot)
end

function TAutoConnectOnBoot.new(AutoConnectOnBoot)
    return TAutoConnectOnBoot_from_obj({AutoConnectOnBoot = AutoConnectOnBoot})
end
---@param obj NetworkPort.AutoConnectOnBoot
function TAutoConnectOnBoot:init_from_obj(obj)
    self.AutoConnectOnBoot = obj.AutoConnectOnBoot
end

function TAutoConnectOnBoot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAutoConnectOnBoot.group)
end

TAutoConnectOnBoot.from_obj = TAutoConnectOnBoot_from_obj

TAutoConnectOnBoot.proto_property = {'AutoConnectOnBoot'}

TAutoConnectOnBoot.default = {false}

TAutoConnectOnBoot.struct = {{name = 'AutoConnectOnBoot', is_array = false, struct = nil}}

function TAutoConnectOnBoot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AutoConnectOnBoot', self.AutoConnectOnBoot, 'bool', true, errs, need_convert)

    TAutoConnectOnBoot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAutoConnectOnBoot.proto_property, errs, need_convert)
    return self
end

function TAutoConnectOnBoot:unpack(_)
    return self.AutoConnectOnBoot
end

NetworkPort.AutoConnectOnBoot = TAutoConnectOnBoot

---@class NetworkPort.BDF
---@field BDF string
local TBDF = {}
TBDF.__index = TBDF
TBDF.group = {}

local function TBDF_from_obj(obj)
    return setmetatable(obj, TBDF)
end

function TBDF.new(BDF)
    return TBDF_from_obj({BDF = BDF})
end
---@param obj NetworkPort.BDF
function TBDF:init_from_obj(obj)
    self.BDF = obj.BDF
end

function TBDF:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBDF.group)
end

TBDF.from_obj = TBDF_from_obj

TBDF.proto_property = {'BDF'}

TBDF.default = {''}

TBDF.struct = {{name = 'BDF', is_array = false, struct = nil}}

function TBDF:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BDF', self.BDF, 'string', true, errs, need_convert)

    TBDF:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBDF.proto_property, errs, need_convert)
    return self
end

function TBDF:unpack(_)
    return self.BDF
end

NetworkPort.BDF = TBDF

---@class NetworkPort.FunctionType
---@field FunctionType string
local TFunctionType = {}
TFunctionType.__index = TFunctionType
TFunctionType.group = {}

local function TFunctionType_from_obj(obj)
    return setmetatable(obj, TFunctionType)
end

function TFunctionType.new(FunctionType)
    return TFunctionType_from_obj({FunctionType = FunctionType or [=[Physical]=]})
end
---@param obj NetworkPort.FunctionType
function TFunctionType:init_from_obj(obj)
    self.FunctionType = obj.FunctionType or [=[Physical]=]
end

function TFunctionType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFunctionType.group)
end

TFunctionType.from_obj = TFunctionType_from_obj

TFunctionType.proto_property = {'FunctionType'}

TFunctionType.default = {''}

TFunctionType.struct = {{name = 'FunctionType', is_array = false, struct = nil}}

function TFunctionType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FunctionType', self.FunctionType, 'string', true, errs, need_convert)

    if self.FunctionType ~= nil then
        validate.Enum(prefix .. 'FunctionType', self.FunctionType, '', {'Virtual', 'Physical'}, errs, need_convert)
    end

    TFunctionType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFunctionType.proto_property, errs, need_convert)
    return self
end

function TFunctionType:unpack(_)
    return self.FunctionType
end

NetworkPort.FunctionType = TFunctionType

---@class NetworkPort.WorkMode
---@field WorkMode string
local TWorkMode = {}
TWorkMode.__index = TWorkMode
TWorkMode.group = {}

local function TWorkMode_from_obj(obj)
    return setmetatable(obj, TWorkMode)
end

function TWorkMode.new(WorkMode)
    return TWorkMode_from_obj({WorkMode = WorkMode or [=[NonLoop]=]})
end
---@param obj NetworkPort.WorkMode
function TWorkMode:init_from_obj(obj)
    self.WorkMode = obj.WorkMode or [=[NonLoop]=]
end

function TWorkMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWorkMode.group)
end

TWorkMode.from_obj = TWorkMode_from_obj

TWorkMode.proto_property = {'WorkMode'}

TWorkMode.default = {''}

TWorkMode.struct = {{name = 'WorkMode', is_array = false, struct = nil}}

function TWorkMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'WorkMode', self.WorkMode, 'string', true, errs, need_convert)

    if self.WorkMode ~= nil then
        validate.Enum(prefix .. 'WorkMode', self.WorkMode, '', {'Loop', 'NonLoop'}, errs, need_convert)
    end

    TWorkMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWorkMode.proto_property, errs, need_convert)
    return self
end

function TWorkMode:unpack(_)
    return self.WorkMode
end

NetworkPort.WorkMode = TWorkMode

---@class NetworkPort.IPv6DefaultGateway
---@field IPv6DefaultGateway string
local TIPv6DefaultGateway = {}
TIPv6DefaultGateway.__index = TIPv6DefaultGateway
TIPv6DefaultGateway.group = {}

local function TIPv6DefaultGateway_from_obj(obj)
    return setmetatable(obj, TIPv6DefaultGateway)
end

function TIPv6DefaultGateway.new(IPv6DefaultGateway)
    return TIPv6DefaultGateway_from_obj({IPv6DefaultGateway = IPv6DefaultGateway})
end
---@param obj NetworkPort.IPv6DefaultGateway
function TIPv6DefaultGateway:init_from_obj(obj)
    self.IPv6DefaultGateway = obj.IPv6DefaultGateway
end

function TIPv6DefaultGateway:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIPv6DefaultGateway.group)
end

TIPv6DefaultGateway.from_obj = TIPv6DefaultGateway_from_obj

TIPv6DefaultGateway.proto_property = {'IPv6DefaultGateway'}

TIPv6DefaultGateway.default = {''}

TIPv6DefaultGateway.struct = {{name = 'IPv6DefaultGateway', is_array = false, struct = nil}}

function TIPv6DefaultGateway:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'IPv6DefaultGateway', self.IPv6DefaultGateway, 'string', true, errs, need_convert)

    TIPv6DefaultGateway:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIPv6DefaultGateway.proto_property, errs, need_convert)
    return self
end

function TIPv6DefaultGateway:unpack(_)
    return self.IPv6DefaultGateway
end

NetworkPort.IPv6DefaultGateway = TIPv6DefaultGateway

---@class NetworkPort.LinkStatusNumeric
---@field LinkStatusNumeric integer
local TLinkStatusNumeric = {}
TLinkStatusNumeric.__index = TLinkStatusNumeric
TLinkStatusNumeric.group = {}

local function TLinkStatusNumeric_from_obj(obj)
    return setmetatable(obj, TLinkStatusNumeric)
end

function TLinkStatusNumeric.new(LinkStatusNumeric)
    return TLinkStatusNumeric_from_obj({LinkStatusNumeric = LinkStatusNumeric or 255})
end
---@param obj NetworkPort.LinkStatusNumeric
function TLinkStatusNumeric:init_from_obj(obj)
    self.LinkStatusNumeric = obj.LinkStatusNumeric or 255
end

function TLinkStatusNumeric:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkStatusNumeric.group)
end

TLinkStatusNumeric.from_obj = TLinkStatusNumeric_from_obj

TLinkStatusNumeric.proto_property = {'LinkStatusNumeric'}

TLinkStatusNumeric.default = {0}

TLinkStatusNumeric.struct = {{name = 'LinkStatusNumeric', is_array = false, struct = nil}}

function TLinkStatusNumeric:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkStatusNumeric', self.LinkStatusNumeric, 'uint8', false, errs, need_convert)

    TLinkStatusNumeric:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkStatusNumeric.proto_property, errs, need_convert)
    return self
end

function TLinkStatusNumeric:unpack(_)
    return self.LinkStatusNumeric
end

NetworkPort.LinkStatusNumeric = TLinkStatusNumeric

---@class NetworkPort.OSLinkStatus
---@field OSLinkStatus string
local TOSLinkStatus = {}
TOSLinkStatus.__index = TOSLinkStatus
TOSLinkStatus.group = {}

local function TOSLinkStatus_from_obj(obj)
    return setmetatable(obj, TOSLinkStatus)
end

function TOSLinkStatus.new(OSLinkStatus)
    return TOSLinkStatus_from_obj({OSLinkStatus = OSLinkStatus})
end
---@param obj NetworkPort.OSLinkStatus
function TOSLinkStatus:init_from_obj(obj)
    self.OSLinkStatus = obj.OSLinkStatus
end

function TOSLinkStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TOSLinkStatus.group)
end

TOSLinkStatus.from_obj = TOSLinkStatus_from_obj

TOSLinkStatus.proto_property = {'OSLinkStatus'}

TOSLinkStatus.default = {''}

TOSLinkStatus.struct = {{name = 'OSLinkStatus', is_array = false, struct = nil}}

function TOSLinkStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OSLinkStatus', self.OSLinkStatus, 'string', false, errs, need_convert)

    TOSLinkStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TOSLinkStatus.proto_property, errs, need_convert)
    return self
end

function TOSLinkStatus:unpack(_)
    return self.OSLinkStatus
end

NetworkPort.OSLinkStatus = TOSLinkStatus

---@class NetworkPort.LinkStatus
---@field LinkStatus string
local TLinkStatus = {}
TLinkStatus.__index = TLinkStatus
TLinkStatus.group = {}

local function TLinkStatus_from_obj(obj)
    return setmetatable(obj, TLinkStatus)
end

function TLinkStatus.new(LinkStatus)
    return TLinkStatus_from_obj({LinkStatus = LinkStatus})
end
---@param obj NetworkPort.LinkStatus
function TLinkStatus:init_from_obj(obj)
    self.LinkStatus = obj.LinkStatus
end

function TLinkStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkStatus.group)
end

TLinkStatus.from_obj = TLinkStatus_from_obj

TLinkStatus.proto_property = {'LinkStatus'}

TLinkStatus.default = {''}

TLinkStatus.struct = {{name = 'LinkStatus', is_array = false, struct = nil}}

function TLinkStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkStatus', self.LinkStatus, 'string', false, errs, need_convert)

    if self.LinkStatus ~= nil then
        validate.Enum(prefix .. 'LinkStatus', self.LinkStatus, '',
            {'LinkUp', 'NoLink', 'LinkDown', 'N/A', 'Connected', 'Disconnected'}, errs, need_convert)
    end

    TLinkStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkStatus.proto_property, errs, need_convert)
    return self
end

function TLinkStatus:unpack(_)
    return self.LinkStatus
end

NetworkPort.LinkStatus = TLinkStatus

---@class NetworkPort.MACAddress
---@field MACAddress string
local TMACAddress = {}
TMACAddress.__index = TMACAddress
TMACAddress.group = {}

local function TMACAddress_from_obj(obj)
    return setmetatable(obj, TMACAddress)
end

function TMACAddress.new(MACAddress)
    return TMACAddress_from_obj({MACAddress = MACAddress or [=[00:00:00:00:00:00]=]})
end
---@param obj NetworkPort.MACAddress
function TMACAddress:init_from_obj(obj)
    self.MACAddress = obj.MACAddress or [=[00:00:00:00:00:00]=]
end

function TMACAddress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMACAddress.group)
end

TMACAddress.from_obj = TMACAddress_from_obj

TMACAddress.proto_property = {'MACAddress'}

TMACAddress.default = {''}

TMACAddress.struct = {{name = 'MACAddress', is_array = false, struct = nil}}

function TMACAddress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MACAddress', self.MACAddress, 'string', true, errs, need_convert)

    TMACAddress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMACAddress.proto_property, errs, need_convert)
    return self
end

function TMACAddress:unpack(_)
    return self.MACAddress
end

NetworkPort.MACAddress = TMACAddress

---@class NetworkPort.PermanentMACAddress
---@field PermanentMACAddress string
local TPermanentMACAddress = {}
TPermanentMACAddress.__index = TPermanentMACAddress
TPermanentMACAddress.group = {}

local function TPermanentMACAddress_from_obj(obj)
    return setmetatable(obj, TPermanentMACAddress)
end

function TPermanentMACAddress.new(PermanentMACAddress)
    return TPermanentMACAddress_from_obj({PermanentMACAddress = PermanentMACAddress or [=[00:00:00:00:00:00]=]})
end
---@param obj NetworkPort.PermanentMACAddress
function TPermanentMACAddress:init_from_obj(obj)
    self.PermanentMACAddress = obj.PermanentMACAddress or [=[00:00:00:00:00:00]=]
end

function TPermanentMACAddress:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPermanentMACAddress.group)
end

TPermanentMACAddress.from_obj = TPermanentMACAddress_from_obj

TPermanentMACAddress.proto_property = {'PermanentMACAddress'}

TPermanentMACAddress.default = {''}

TPermanentMACAddress.struct = {{name = 'PermanentMACAddress', is_array = false, struct = nil}}

function TPermanentMACAddress:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PermanentMACAddress', self.PermanentMACAddress, 'string', true, errs, need_convert)

    TPermanentMACAddress:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPermanentMACAddress.proto_property, errs, need_convert)
    return self
end

function TPermanentMACAddress:unpack(_)
    return self.PermanentMACAddress
end

NetworkPort.PermanentMACAddress = TPermanentMACAddress

---@class NetworkPort.PortID
---@field PortID integer
local TPortID = {}
TPortID.__index = TPortID
TPortID.group = {}

local function TPortID_from_obj(obj)
    return setmetatable(obj, TPortID)
end

function TPortID.new(PortID)
    return TPortID_from_obj({PortID = PortID})
end
---@param obj NetworkPort.PortID
function TPortID:init_from_obj(obj)
    self.PortID = obj.PortID
end

function TPortID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortID.group)
end

TPortID.from_obj = TPortID_from_obj

TPortID.proto_property = {'PortID'}

TPortID.default = {0}

TPortID.struct = {{name = 'PortID', is_array = false, struct = nil}}

function TPortID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'PortID', self.PortID, 'uint8', true, errs, need_convert)

    TPortID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortID.proto_property, errs, need_convert)
    return self
end

function TPortID:unpack(_)
    return self.PortID
end

NetworkPort.PortID = TPortID

---@class NetworkPort.Type
---@field Type integer
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj NetworkPort.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {0}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'uint8', true, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

NetworkPort.Type = TType

---@class NetworkPort.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj NetworkPort.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', true, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

NetworkPort.Name = TName

---@class NetworkPort.SystemID
---@field SystemID integer
local TSystemID = {}
TSystemID.__index = TSystemID
TSystemID.group = {}

local function TSystemID_from_obj(obj)
    return setmetatable(obj, TSystemID)
end

function TSystemID.new(SystemID)
    return TSystemID_from_obj({SystemID = SystemID})
end
---@param obj NetworkPort.SystemID
function TSystemID:init_from_obj(obj)
    self.SystemID = obj.SystemID
end

function TSystemID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemID.group)
end

TSystemID.from_obj = TSystemID_from_obj

TSystemID.proto_property = {'SystemID'}

TSystemID.default = {0}

TSystemID.struct = {{name = 'SystemID', is_array = false, struct = nil}}

function TSystemID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemID', self.SystemID, 'uint8', true, errs, need_convert)

    TSystemID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemID.proto_property, errs, need_convert)
    return self
end

function TSystemID:unpack(_)
    return self.SystemID
end

NetworkPort.SystemID = TSystemID

---@class NetworkPort.ConfigureRsp
---@field TaskId integer
local TConfigureRsp = {}
TConfigureRsp.__index = TConfigureRsp
TConfigureRsp.group = {}

local function TConfigureRsp_from_obj(obj)
    return setmetatable(obj, TConfigureRsp)
end

function TConfigureRsp.new(TaskId)
    return TConfigureRsp_from_obj({TaskId = TaskId})
end
---@param obj NetworkPort.ConfigureRsp
function TConfigureRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TConfigureRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConfigureRsp.group)
end

TConfigureRsp.from_obj = TConfigureRsp_from_obj

TConfigureRsp.proto_property = {'TaskId'}

TConfigureRsp.default = {0}

TConfigureRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TConfigureRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TConfigureRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConfigureRsp.proto_property, errs, need_convert)
    return self
end

function TConfigureRsp:unpack(_)
    return self.TaskId
end

NetworkPort.ConfigureRsp = TConfigureRsp

---@class NetworkPort.Object
---@field key string
---@field value string
local TObject = {}
TObject.__index = TObject
TObject.group = {}

local function TObject_from_obj(obj)
    return setmetatable(obj, TObject)
end

function TObject.new(dict)
    return TObject_from_obj(dict)
end

---@param obj NetworkPort.Object
function TObject:init_from_obj(obj)
    self = obj
end

function TObject:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TObject.group)
end

TObject.from_obj = TObject_from_obj

TObject.proto_property = {}

TObject.default = {}

TObject.struct = {}

function TObject:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TObject:remove_error_props(errs, self)
    return self
end

function TObject:unpack(_)
    return self
end

NetworkPort.Object = TObject

---@class NetworkPort.ConfigureReq
---@field Request NetworkPort.Object
local TConfigureReq = {}
TConfigureReq.__index = TConfigureReq
TConfigureReq.group = {}

local function TConfigureReq_from_obj(obj)
    return setmetatable(obj, TConfigureReq)
end

function TConfigureReq.new(Request)
    return TConfigureReq_from_obj({Request = Request})
end
---@param obj NetworkPort.ConfigureReq
function TConfigureReq:init_from_obj(obj)
    self.Request = obj.Request
end

function TConfigureReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConfigureReq.group)
end

TConfigureReq.from_obj = TConfigureReq_from_obj

TConfigureReq.proto_property = {'Request'}

TConfigureReq.default = {NetworkPort.Object.default}

TConfigureReq.struct = {{name = 'Request', is_array = false, struct = NetworkPort.Object.struct}}

function TConfigureReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    NetworkPort.Object.new(self.Request):validate(prefix, errs, need_convert)

    TConfigureReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConfigureReq.proto_property, errs, need_convert)
    return self
end

function TConfigureReq:unpack(_)
    return self.Request
end

NetworkPort.ConfigureReq = TConfigureReq

NetworkPort.interface = mdb.register_interface('bmc.kepler.Systems.NetworkPort', {
    SystemID = {'y', nil, true, nil, false},
    Name = {'s', nil, true, nil, false},
    Type = {'y', nil, true, nil, false},
    PortID = {'y', nil, true, nil, false},
    PermanentMACAddress = {'s', nil, true, '00:00:00:00:00:00', false},
    MACAddress = {'s', nil, true, '00:00:00:00:00:00', false},
    LinkStatus = {'s', nil, false, nil, false},
    OSLinkStatus = {'s', {}, false, nil, false},
    LinkStatusNumeric = {'y', nil, false, 255, false},
    IPv6DefaultGateway = {'s', nil, true, nil, false},
    WorkMode = {'s', nil, true, 'NonLoop', false},
    FunctionType = {'s', nil, true, 'Physical', false},
    BDF = {'s', nil, true, nil, false},
    AutoConnectOnBoot = {'b', nil, true, nil, false},
    NetDevFuncType = {'y', nil, true, 1, false},
    MediumType = {'s', nil, true, 'Copper', false},
    SpeedMbps = {'u', {'VOLATILE'}, true, 4294967295, false},
    FullDuplex = {'b', nil, true, nil, false},
    AutoSpeedNegotiation = {'b', nil, true, nil, false},
    FirmwareVersion = {'s', nil, true, nil, false},
    DriverName = {'s', nil, true, nil, false},
    DriverVersion = {'s', nil, true, nil, false},
    LLDPEnabled = {'b', nil, false, nil, false},
    SupportedLinkCapability = {'s', nil, true, nil, false},
    NetworkAdapterId = {'s', nil, true, nil, false},
    LinkMonitorPeriodMS = {'u', nil, true, nil, false},
    UUID = {'s', nil, true, nil, false},
    WorkloadType = {'y', nil, true, nil, false},
    NodeId = {'s', nil, true, nil, false}
}, {Configure = {'a{ss}a{ss}', 'u', TConfigureReq, TConfigureRsp}}, {})

return NetworkPort
