-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local LLDPReceive = {}

---@class LLDPReceive.ManagementVlanId
---@field ManagementVlanId integer
local TManagementVlanId = {}
TManagementVlanId.__index = TManagementVlanId
TManagementVlanId.group = {}

local function TManagementVlanId_from_obj(obj)
    return setmetatable(obj, TManagementVlanId)
end

function TManagementVlanId.new(ManagementVlanId)
    return TManagementVlanId_from_obj({ManagementVlanId = ManagementVlanId})
end
---@param obj LLDPReceive.ManagementVlanId
function TManagementVlanId:init_from_obj(obj)
    self.ManagementVlanId = obj.ManagementVlanId
end

function TManagementVlanId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TManagementVlanId.group)
end

TManagementVlanId.from_obj = TManagementVlanId_from_obj

TManagementVlanId.proto_property = {'ManagementVlanId'}

TManagementVlanId.default = {0}

TManagementVlanId.struct = {{name = 'ManagementVlanId', is_array = false, struct = nil}}

function TManagementVlanId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManagementVlanId', self.ManagementVlanId, 'uint16', true, errs, need_convert)

    TManagementVlanId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TManagementVlanId.proto_property, errs, need_convert)
    return self
end

function TManagementVlanId:unpack(_)
    return self.ManagementVlanId
end

LLDPReceive.ManagementVlanId = TManagementVlanId

---@class LLDPReceive.SystemName
---@field SystemName string
local TSystemName = {}
TSystemName.__index = TSystemName
TSystemName.group = {}

local function TSystemName_from_obj(obj)
    return setmetatable(obj, TSystemName)
end

function TSystemName.new(SystemName)
    return TSystemName_from_obj({SystemName = SystemName})
end
---@param obj LLDPReceive.SystemName
function TSystemName:init_from_obj(obj)
    self.SystemName = obj.SystemName
end

function TSystemName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemName.group)
end

TSystemName.from_obj = TSystemName_from_obj

TSystemName.proto_property = {'SystemName'}

TSystemName.default = {''}

TSystemName.struct = {{name = 'SystemName', is_array = false, struct = nil}}

function TSystemName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemName', self.SystemName, 'string', true, errs, need_convert)

    TSystemName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemName.proto_property, errs, need_convert)
    return self
end

function TSystemName:unpack(_)
    return self.SystemName
end

LLDPReceive.SystemName = TSystemName

---@class LLDPReceive.PortIdSubtype
---@field PortIdSubtype string
local TPortIdSubtype = {}
TPortIdSubtype.__index = TPortIdSubtype
TPortIdSubtype.group = {}

local function TPortIdSubtype_from_obj(obj)
    return setmetatable(obj, TPortIdSubtype)
end

function TPortIdSubtype.new(PortIdSubtype)
    return TPortIdSubtype_from_obj({PortIdSubtype = PortIdSubtype})
end
---@param obj LLDPReceive.PortIdSubtype
function TPortIdSubtype:init_from_obj(obj)
    self.PortIdSubtype = obj.PortIdSubtype
end

function TPortIdSubtype:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortIdSubtype.group)
end

TPortIdSubtype.from_obj = TPortIdSubtype_from_obj

TPortIdSubtype.proto_property = {'PortIdSubtype'}

TPortIdSubtype.default = {''}

TPortIdSubtype.struct = {{name = 'PortIdSubtype', is_array = false, struct = nil}}

function TPortIdSubtype:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PortIdSubtype', self.PortIdSubtype, 'string', true, errs, need_convert)

    TPortIdSubtype:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortIdSubtype.proto_property, errs, need_convert)
    return self
end

function TPortIdSubtype:unpack(_)
    return self.PortIdSubtype
end

LLDPReceive.PortIdSubtype = TPortIdSubtype

---@class LLDPReceive.PortId
---@field PortId string
local TPortId = {}
TPortId.__index = TPortId
TPortId.group = {}

local function TPortId_from_obj(obj)
    return setmetatable(obj, TPortId)
end

function TPortId.new(PortId)
    return TPortId_from_obj({PortId = PortId})
end
---@param obj LLDPReceive.PortId
function TPortId:init_from_obj(obj)
    self.PortId = obj.PortId
end

function TPortId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortId.group)
end

TPortId.from_obj = TPortId_from_obj

TPortId.proto_property = {'PortId'}

TPortId.default = {''}

TPortId.struct = {{name = 'PortId', is_array = false, struct = nil}}

function TPortId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PortId', self.PortId, 'string', true, errs, need_convert)

    TPortId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortId.proto_property, errs, need_convert)
    return self
end

function TPortId:unpack(_)
    return self.PortId
end

LLDPReceive.PortId = TPortId

---@class LLDPReceive.ChassisIdSubtype
---@field ChassisIdSubtype string
local TChassisIdSubtype = {}
TChassisIdSubtype.__index = TChassisIdSubtype
TChassisIdSubtype.group = {}

local function TChassisIdSubtype_from_obj(obj)
    return setmetatable(obj, TChassisIdSubtype)
end

function TChassisIdSubtype.new(ChassisIdSubtype)
    return TChassisIdSubtype_from_obj({ChassisIdSubtype = ChassisIdSubtype})
end
---@param obj LLDPReceive.ChassisIdSubtype
function TChassisIdSubtype:init_from_obj(obj)
    self.ChassisIdSubtype = obj.ChassisIdSubtype
end

function TChassisIdSubtype:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChassisIdSubtype.group)
end

TChassisIdSubtype.from_obj = TChassisIdSubtype_from_obj

TChassisIdSubtype.proto_property = {'ChassisIdSubtype'}

TChassisIdSubtype.default = {''}

TChassisIdSubtype.struct = {{name = 'ChassisIdSubtype', is_array = false, struct = nil}}

function TChassisIdSubtype:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChassisIdSubtype', self.ChassisIdSubtype, 'string', true, errs, need_convert)

    TChassisIdSubtype:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChassisIdSubtype.proto_property, errs, need_convert)
    return self
end

function TChassisIdSubtype:unpack(_)
    return self.ChassisIdSubtype
end

LLDPReceive.ChassisIdSubtype = TChassisIdSubtype

---@class LLDPReceive.ChassisId
---@field ChassisId string
local TChassisId = {}
TChassisId.__index = TChassisId
TChassisId.group = {}

local function TChassisId_from_obj(obj)
    return setmetatable(obj, TChassisId)
end

function TChassisId.new(ChassisId)
    return TChassisId_from_obj({ChassisId = ChassisId})
end
---@param obj LLDPReceive.ChassisId
function TChassisId:init_from_obj(obj)
    self.ChassisId = obj.ChassisId
end

function TChassisId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChassisId.group)
end

TChassisId.from_obj = TChassisId_from_obj

TChassisId.proto_property = {'ChassisId'}

TChassisId.default = {''}

TChassisId.struct = {{name = 'ChassisId', is_array = false, struct = nil}}

function TChassisId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChassisId', self.ChassisId, 'string', true, errs, need_convert)

    TChassisId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChassisId.proto_property, errs, need_convert)
    return self
end

function TChassisId:unpack(_)
    return self.ChassisId
end

LLDPReceive.ChassisId = TChassisId

LLDPReceive.interface = mdb.register_interface('bmc.kepler.Systems.NetworkPort.LLDPReceive', {
    ChassisId = {'s', nil, true, nil, false},
    ChassisIdSubtype = {'s', nil, true, nil, false},
    PortId = {'s', nil, true, nil, false},
    PortIdSubtype = {'s', nil, true, nil, false},
    SystemName = {'s', nil, true, nil, false},
    ManagementVlanId = {'q', nil, true, nil, false}
}, {}, {})

return LLDPReceive
