-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Fault = {}

---@class Fault.LinkDown
---@field LinkDown integer
local TLinkDown = {}
TLinkDown.__index = TLinkDown
TLinkDown.group = {}

local function TLinkDown_from_obj(obj)
    return setmetatable(obj, TLinkDown)
end

function TLinkDown.new(LinkDown)
    return TLinkDown_from_obj({LinkDown = LinkDown})
end
---@param obj Fault.LinkDown
function TLinkDown:init_from_obj(obj)
    self.LinkDown = obj.LinkDown
end

function TLinkDown:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkDown.group)
end

TLinkDown.from_obj = TLinkDown_from_obj

TLinkDown.proto_property = {'LinkDown'}

TLinkDown.default = {0}

TLinkDown.struct = {{name = 'LinkDown', is_array = false, struct = nil}}

function TLinkDown:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkDown', self.LinkDown, 'uint8', true, errs, need_convert)

    TLinkDown:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkDown.proto_property, errs, need_convert)
    return self
end

function TLinkDown:unpack(_)
    return self.LinkDown
end

Fault.LinkDown = TLinkDown

Fault.interface = mdb.register_interface('bmc.kepler.Systems.NetworkPort.Fault',
    {LinkDown = {'y', nil, true, nil, false}}, {}, {})

return Fault
