--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetNcsiSlot = {}

---@class NetworkAdapterIpmiCmds.GetNcsiSlotReq
---@field ManuId integer
local TGetNcsiSlotReq = {}
TGetNcsiSlotReq.__index = TGetNcsiSlotReq
TGetNcsiSlotReq.group = {}

local function TGetNcsiSlotReq_from_obj(obj)
    return setmetatable(obj, TGetNcsiSlotReq)
end

function TGetNcsiSlotReq.new(ManuId)
    return TGetNcsiSlotReq_from_obj({ManuId = ManuId})
end
---@param obj NetworkAdapterIpmiCmds.GetNcsiSlotReq
function TGetNcsiSlotReq:init_from_obj(obj)
    self.ManuId = obj.ManuId
end

function TGetNcsiSlotReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNcsiSlotReq.group)
end

TGetNcsiSlotReq.from_obj = TGetNcsiSlotReq_from_obj

TGetNcsiSlotReq.proto_property = {'ManuId'}

TGetNcsiSlotReq.default = {0}

TGetNcsiSlotReq.struct = {{name = 'ManuId', is_array = false, struct = nil}}

function TGetNcsiSlotReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManuId', self.ManuId, 'uint32', false, errs, need_convert)

    TGetNcsiSlotReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNcsiSlotReq.proto_property, errs, need_convert)
    return self
end

function TGetNcsiSlotReq:unpack(_)
    return self.ManuId
end

GetNcsiSlot.GetNcsiSlotReq = TGetNcsiSlotReq

---@class NetworkAdapterIpmiCmds.GetNcsiSlotRsp
---@field CompletionCode integer
---@field ManuId integer
---@field Slot integer
local TGetNcsiSlotRsp = {}
TGetNcsiSlotRsp.__index = TGetNcsiSlotRsp
TGetNcsiSlotRsp.group = {}

local function TGetNcsiSlotRsp_from_obj(obj)
    return setmetatable(obj, TGetNcsiSlotRsp)
end

function TGetNcsiSlotRsp.new(CompletionCode, ManuId, Slot)
    return TGetNcsiSlotRsp_from_obj({CompletionCode = CompletionCode, ManuId = ManuId, Slot = Slot})
end
---@param obj NetworkAdapterIpmiCmds.GetNcsiSlotRsp
function TGetNcsiSlotRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManuId = obj.ManuId
    self.Slot = obj.Slot
end

function TGetNcsiSlotRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNcsiSlotRsp.group)
end

TGetNcsiSlotRsp.from_obj = TGetNcsiSlotRsp_from_obj

TGetNcsiSlotRsp.proto_property = {'CompletionCode', 'ManuId', 'Slot'}

TGetNcsiSlotRsp.default = {0, 0, 0}

TGetNcsiSlotRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManuId', is_array = false, struct = nil},
    {name = 'Slot', is_array = false, struct = nil}
}

function TGetNcsiSlotRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManuId', self.ManuId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Slot', self.Slot, 'uint8', false, errs, need_convert)

    TGetNcsiSlotRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNcsiSlotRsp.proto_property, errs, need_convert)
    return self
end

function TGetNcsiSlotRsp:unpack(_)
    return self.CompletionCode, self.ManuId, self.Slot
end

GetNcsiSlot.GetNcsiSlotRsp = TGetNcsiSlotRsp

return GetNcsiSlot
