--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDpuForcePowerOnState = {}

---@class NetworkAdapterIpmiCmds.GetDpuForcePowerOnStateReq
---@field ManufactureId integer
---@field Offset integer
---@field Length integer
local TGetDpuForcePowerOnStateReq = {}
TGetDpuForcePowerOnStateReq.__index = TGetDpuForcePowerOnStateReq
TGetDpuForcePowerOnStateReq.group = {}

local function TGetDpuForcePowerOnStateReq_from_obj(obj)
    return setmetatable(obj, TGetDpuForcePowerOnStateReq)
end

function TGetDpuForcePowerOnStateReq.new(ManufactureId, Offset, Length)
    return TGetDpuForcePowerOnStateReq_from_obj({ManufactureId = ManufactureId, Offset = Offset, Length = Length})
end
---@param obj NetworkAdapterIpmiCmds.GetDpuForcePowerOnStateReq
function TGetDpuForcePowerOnStateReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Offset = obj.Offset
    self.Length = obj.Length
end

function TGetDpuForcePowerOnStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuForcePowerOnStateReq.group)
end

TGetDpuForcePowerOnStateReq.from_obj = TGetDpuForcePowerOnStateReq_from_obj

TGetDpuForcePowerOnStateReq.proto_property = {'ManufactureId', 'Offset', 'Length'}

TGetDpuForcePowerOnStateReq.default = {0, 0, 0}

TGetDpuForcePowerOnStateReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Offset', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}
}

function TGetDpuForcePowerOnStateReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Offset', self.Offset, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)

    TGetDpuForcePowerOnStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuForcePowerOnStateReq.proto_property, errs, need_convert)
    return self
end

function TGetDpuForcePowerOnStateReq:unpack(_)
    return self.ManufactureId, self.Offset, self.Length
end

GetDpuForcePowerOnState.GetDpuForcePowerOnStateReq = TGetDpuForcePowerOnStateReq

---@class NetworkAdapterIpmiCmds.GetDpuForcePowerOnStateRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field EndOfList integer
---@field ForcePowerStatus integer
local TGetDpuForcePowerOnStateRsp = {}
TGetDpuForcePowerOnStateRsp.__index = TGetDpuForcePowerOnStateRsp
TGetDpuForcePowerOnStateRsp.group = {}

local function TGetDpuForcePowerOnStateRsp_from_obj(obj)
    return setmetatable(obj, TGetDpuForcePowerOnStateRsp)
end

function TGetDpuForcePowerOnStateRsp.new(CompletionCode, ManufactureId, EndOfList, ForcePowerStatus)
    return TGetDpuForcePowerOnStateRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        EndOfList = EndOfList,
        ForcePowerStatus = ForcePowerStatus
    })
end
---@param obj NetworkAdapterIpmiCmds.GetDpuForcePowerOnStateRsp
function TGetDpuForcePowerOnStateRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.EndOfList = obj.EndOfList
    self.ForcePowerStatus = obj.ForcePowerStatus
end

function TGetDpuForcePowerOnStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDpuForcePowerOnStateRsp.group)
end

TGetDpuForcePowerOnStateRsp.from_obj = TGetDpuForcePowerOnStateRsp_from_obj

TGetDpuForcePowerOnStateRsp.proto_property = {'CompletionCode', 'ManufactureId', 'EndOfList', 'ForcePowerStatus'}

TGetDpuForcePowerOnStateRsp.default = {0, 0, 0, 0}

TGetDpuForcePowerOnStateRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'EndOfList', is_array = false, struct = nil}, {name = 'ForcePowerStatus', is_array = false, struct = nil}
}

function TGetDpuForcePowerOnStateRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'EndOfList', self.EndOfList, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ForcePowerStatus', self.ForcePowerStatus, 'uint8', false, errs, need_convert)

    TGetDpuForcePowerOnStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDpuForcePowerOnStateRsp.proto_property, errs, need_convert)
    return self
end

function TGetDpuForcePowerOnStateRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.EndOfList, self.ForcePowerStatus
end

GetDpuForcePowerOnState.GetDpuForcePowerOnStateRsp = TGetDpuForcePowerOnStateRsp

return GetDpuForcePowerOnState
