-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MPortUsageHistory = {}

---@class MPortUsageHistory.Percent
---@field Percent integer
local TPercent = {}
TPercent.__index = TPercent
TPercent.group = {}

local function TPercent_from_obj(obj)
    return setmetatable(obj, TPercent)
end

function TPercent.new(Percent)
    return TPercent_from_obj({Percent = Percent})
end
---@param obj MPortUsageHistory.Percent
function TPercent:init_from_obj(obj)
    self.Percent = obj.Percent
end

function TPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPercent.group)
end

TPercent.from_obj = TPercent_from_obj

TPercent.proto_property = {'Percent'}

TPercent.default = {0}

TPercent.struct = {{name = 'Percent', is_array = false, struct = nil}}

function TPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Percent', self.Percent, 'uint8', false, errs, need_convert)

    TPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPercent.proto_property, errs, need_convert)
    return self
end

function TPercent:unpack(_)
    return self.Percent
end

MPortUsageHistory.Percent = TPercent

---@class MPortUsageHistory.Time
---@field Time integer
local TTime = {}
TTime.__index = TTime
TTime.group = {}

local function TTime_from_obj(obj)
    return setmetatable(obj, TTime)
end

function TTime.new(Time)
    return TTime_from_obj({Time = Time})
end
---@param obj MPortUsageHistory.Time
function TTime:init_from_obj(obj)
    self.Time = obj.Time
end

function TTime:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTime.group)
end

TTime.from_obj = TTime_from_obj

TTime.proto_property = {'Time'}

TTime.default = {0}

TTime.struct = {{name = 'Time', is_array = false, struct = nil}}

function TTime:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Time', self.Time, 'uint32', false, errs, need_convert)

    TTime:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTime.proto_property, errs, need_convert)
    return self
end

function TTime:unpack(_)
    return self.Time
end

MPortUsageHistory.Time = TTime

---@class MPortUsageHistory.PortID
---@field PortID integer
local TPortID = {}
TPortID.__index = TPortID
TPortID.group = {}

local function TPortID_from_obj(obj)
    return setmetatable(obj, TPortID)
end

function TPortID.new(PortID)
    return TPortID_from_obj({PortID = PortID})
end
---@param obj MPortUsageHistory.PortID
function TPortID:init_from_obj(obj)
    self.PortID = obj.PortID
end

function TPortID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortID.group)
end

TPortID.from_obj = TPortID_from_obj

TPortID.proto_property = {'PortID'}

TPortID.default = {0}

TPortID.struct = {{name = 'PortID', is_array = false, struct = nil}}

function TPortID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'PortID', self.PortID, 'uint8', false, errs, need_convert)

    TPortID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortID.proto_property, errs, need_convert)
    return self
end

function TPortID:unpack(_)
    return self.PortID
end

MPortUsageHistory.PortID = TPortID

---@class MPortUsageHistory.NetworkAdapterId
---@field NetworkAdapterId string
local TNetworkAdapterId = {}
TNetworkAdapterId.__index = TNetworkAdapterId
TNetworkAdapterId.group = {}

local function TNetworkAdapterId_from_obj(obj)
    return setmetatable(obj, TNetworkAdapterId)
end

function TNetworkAdapterId.new(NetworkAdapterId)
    return TNetworkAdapterId_from_obj({NetworkAdapterId = NetworkAdapterId})
end
---@param obj MPortUsageHistory.NetworkAdapterId
function TNetworkAdapterId:init_from_obj(obj)
    self.NetworkAdapterId = obj.NetworkAdapterId
end

function TNetworkAdapterId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNetworkAdapterId.group)
end

TNetworkAdapterId.from_obj = TNetworkAdapterId_from_obj

TNetworkAdapterId.proto_property = {'NetworkAdapterId'}

TNetworkAdapterId.default = {''}

TNetworkAdapterId.struct = {{name = 'NetworkAdapterId', is_array = false, struct = nil}}

function TNetworkAdapterId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'NetworkAdapterId', self.NetworkAdapterId, 'string', false, errs, need_convert)

    TNetworkAdapterId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNetworkAdapterId.proto_property, errs, need_convert)
    return self
end

function TNetworkAdapterId:unpack(_)
    return self.NetworkAdapterId
end

MPortUsageHistory.NetworkAdapterId = TNetworkAdapterId

---@class MPortUsageHistory.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MPortUsageHistory.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MPortUsageHistory.Id = TId

return MPortUsageHistory
