-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MOpticalModule = {}

---@class MOpticalModule.SilkText
---@field SilkText string
local TSilkText = {}
TSilkText.__index = TSilkText
TSilkText.group = {}

local function TSilkText_from_obj(obj)
    return setmetatable(obj, TSilkText)
end

function TSilkText.new(SilkText)
    return TSilkText_from_obj({SilkText = SilkText or [=[]=]})
end
---@param obj MOpticalModule.SilkText
function TSilkText:init_from_obj(obj)
    self.SilkText = obj.SilkText or [=[]=]
end

function TSilkText:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSilkText.group)
end

TSilkText.from_obj = TSilkText_from_obj

TSilkText.proto_property = {'SilkText'}

TSilkText.default = {''}

TSilkText.struct = {{name = 'SilkText', is_array = false, struct = nil}}

function TSilkText:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SilkText', self.SilkText, 'string', false, errs, need_convert)

    TSilkText:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSilkText.proto_property, errs, need_convert)
    return self
end

function TSilkText:unpack(_)
    return self.SilkText
end

MOpticalModule.SilkText = TSilkText

---@class MOpticalModule.CreatedByDeviceObject
---@field CreatedByDeviceObject boolean
local TCreatedByDeviceObject = {}
TCreatedByDeviceObject.__index = TCreatedByDeviceObject
TCreatedByDeviceObject.group = {}

local function TCreatedByDeviceObject_from_obj(obj)
    return setmetatable(obj, TCreatedByDeviceObject)
end

function TCreatedByDeviceObject.new(CreatedByDeviceObject)
    return TCreatedByDeviceObject_from_obj({CreatedByDeviceObject = CreatedByDeviceObject or false})
end
---@param obj MOpticalModule.CreatedByDeviceObject
function TCreatedByDeviceObject:init_from_obj(obj)
    self.CreatedByDeviceObject = obj.CreatedByDeviceObject or false
end

function TCreatedByDeviceObject:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCreatedByDeviceObject.group)
end

TCreatedByDeviceObject.from_obj = TCreatedByDeviceObject_from_obj

TCreatedByDeviceObject.proto_property = {'CreatedByDeviceObject'}

TCreatedByDeviceObject.default = {false}

TCreatedByDeviceObject.struct = {{name = 'CreatedByDeviceObject', is_array = false, struct = nil}}

function TCreatedByDeviceObject:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CreatedByDeviceObject', self.CreatedByDeviceObject, 'bool', false, errs, need_convert)

    TCreatedByDeviceObject:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCreatedByDeviceObject.proto_property, errs, need_convert)
    return self
end

function TCreatedByDeviceObject:unpack(_)
    return self.CreatedByDeviceObject
end

MOpticalModule.CreatedByDeviceObject = TCreatedByDeviceObject

---@class MOpticalModule.PfID
---@field PfID integer
local TPfID = {}
TPfID.__index = TPfID
TPfID.group = {}

local function TPfID_from_obj(obj)
    return setmetatable(obj, TPfID)
end

function TPfID.new(PfID)
    return TPfID_from_obj({PfID = PfID or 255})
end
---@param obj MOpticalModule.PfID
function TPfID:init_from_obj(obj)
    self.PfID = obj.PfID or 255
end

function TPfID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPfID.group)
end

TPfID.from_obj = TPfID_from_obj

TPfID.proto_property = {'PfID'}

TPfID.default = {0}

TPfID.struct = {{name = 'PfID', is_array = false, struct = nil}}

function TPfID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PfID', self.PfID, 'uint8', true, errs, need_convert)

    TPfID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPfID.proto_property, errs, need_convert)
    return self
end

function TPfID:unpack(_)
    return self.PfID
end

MOpticalModule.PfID = TPfID

---@class MOpticalModule.NetworkAdapterId
---@field NetworkAdapterId string
local TNetworkAdapterId = {}
TNetworkAdapterId.__index = TNetworkAdapterId
TNetworkAdapterId.group = {}

local function TNetworkAdapterId_from_obj(obj)
    return setmetatable(obj, TNetworkAdapterId)
end

function TNetworkAdapterId.new(NetworkAdapterId)
    return TNetworkAdapterId_from_obj({NetworkAdapterId = NetworkAdapterId})
end
---@param obj MOpticalModule.NetworkAdapterId
function TNetworkAdapterId:init_from_obj(obj)
    self.NetworkAdapterId = obj.NetworkAdapterId
end

function TNetworkAdapterId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNetworkAdapterId.group)
end

TNetworkAdapterId.from_obj = TNetworkAdapterId_from_obj

TNetworkAdapterId.proto_property = {'NetworkAdapterId'}

TNetworkAdapterId.default = {''}

TNetworkAdapterId.struct = {{name = 'NetworkAdapterId', is_array = false, struct = nil}}

function TNetworkAdapterId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'NetworkAdapterId', self.NetworkAdapterId, 'string', false, errs, need_convert)

    TNetworkAdapterId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNetworkAdapterId.proto_property, errs, need_convert)
    return self
end

function TNetworkAdapterId:unpack(_)
    return self.NetworkAdapterId
end

MOpticalModule.NetworkAdapterId = TNetworkAdapterId

---@class MOpticalModule.PortID
---@field PortID integer
local TPortID = {}
TPortID.__index = TPortID
TPortID.group = {}

local function TPortID_from_obj(obj)
    return setmetatable(obj, TPortID)
end

function TPortID.new(PortID)
    return TPortID_from_obj({PortID = PortID})
end
---@param obj MOpticalModule.PortID
function TPortID:init_from_obj(obj)
    self.PortID = obj.PortID
end

function TPortID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortID.group)
end

TPortID.from_obj = TPortID_from_obj

TPortID.proto_property = {'PortID'}

TPortID.default = {0}

TPortID.struct = {{name = 'PortID', is_array = false, struct = nil}}

function TPortID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'PortID', self.PortID, 'uint8', false, errs, need_convert)

    TPortID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortID.proto_property, errs, need_convert)
    return self
end

function TPortID:unpack(_)
    return self.PortID
end

MOpticalModule.PortID = TPortID

return MOpticalModule
