-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MNetworkBridgePort = {}

---@class MNetworkBridgePort.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj MNetworkBridgePort.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', false, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

MNetworkBridgePort.Name = TName

---@class MNetworkBridgePort.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MNetworkBridgePort.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MNetworkBridgePort.Id = TId

---@class MNetworkBridgePort.BridgeId
---@field BridgeId string
local TBridgeId = {}
TBridgeId.__index = TBridgeId
TBridgeId.group = {}

local function TBridgeId_from_obj(obj)
    return setmetatable(obj, TBridgeId)
end

function TBridgeId.new(BridgeId)
    return TBridgeId_from_obj({BridgeId = BridgeId})
end
---@param obj MNetworkBridgePort.BridgeId
function TBridgeId:init_from_obj(obj)
    self.BridgeId = obj.BridgeId
end

function TBridgeId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBridgeId.group)
end

TBridgeId.from_obj = TBridgeId_from_obj

TBridgeId.proto_property = {'BridgeId'}

TBridgeId.default = {''}

TBridgeId.struct = {{name = 'BridgeId', is_array = false, struct = nil}}

function TBridgeId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'BridgeId', self.BridgeId, 'string', false, errs, need_convert)

    TBridgeId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBridgeId.proto_property, errs, need_convert)
    return self
end

function TBridgeId:unpack(_)
    return self.BridgeId
end

MNetworkBridgePort.BridgeId = TBridgeId

return MNetworkBridgePort
