-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MNcsiNCPortInfo = {}

---@class MNcsiNCPortInfo.MgmtPortId
---@field MgmtPortId integer
local TMgmtPortId = {}
TMgmtPortId.__index = TMgmtPortId
TMgmtPortId.group = {}

local function TMgmtPortId_from_obj(obj)
    return setmetatable(obj, TMgmtPortId)
end

function TMgmtPortId.new(MgmtPortId)
    return TMgmtPortId_from_obj({MgmtPortId = MgmtPortId})
end
---@param obj MNcsiNCPortInfo.MgmtPortId
function TMgmtPortId:init_from_obj(obj)
    self.MgmtPortId = obj.MgmtPortId
end

function TMgmtPortId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMgmtPortId.group)
end

TMgmtPortId.from_obj = TMgmtPortId_from_obj

TMgmtPortId.proto_property = {'MgmtPortId'}

TMgmtPortId.default = {0}

TMgmtPortId.struct = {{name = 'MgmtPortId', is_array = false, struct = nil}}

function TMgmtPortId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'MgmtPortId', self.MgmtPortId, 'uint8', false, errs, need_convert)

    TMgmtPortId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMgmtPortId.proto_property, errs, need_convert)
    return self
end

function TMgmtPortId:unpack(_)
    return self.MgmtPortId
end

MNcsiNCPortInfo.MgmtPortId = TMgmtPortId

---@class MNcsiNCPortInfo.Slikscreen
---@field Slikscreen string
local TSlikscreen = {}
TSlikscreen.__index = TSlikscreen
TSlikscreen.group = {}

local function TSlikscreen_from_obj(obj)
    return setmetatable(obj, TSlikscreen)
end

function TSlikscreen.new(Slikscreen)
    return TSlikscreen_from_obj({Slikscreen = Slikscreen})
end
---@param obj MNcsiNCPortInfo.Slikscreen
function TSlikscreen:init_from_obj(obj)
    self.Slikscreen = obj.Slikscreen
end

function TSlikscreen:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSlikscreen.group)
end

TSlikscreen.from_obj = TSlikscreen_from_obj

TSlikscreen.proto_property = {'Slikscreen'}

TSlikscreen.default = {''}

TSlikscreen.struct = {{name = 'Slikscreen', is_array = false, struct = nil}}

function TSlikscreen:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Slikscreen', self.Slikscreen, 'string', false, errs, need_convert)

    TSlikscreen:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSlikscreen.proto_property, errs, need_convert)
    return self
end

function TSlikscreen:unpack(_)
    return self.Slikscreen
end

MNcsiNCPortInfo.Slikscreen = TSlikscreen

---@class MNcsiNCPortInfo.Type
---@field Type string
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj MNcsiNCPortInfo.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {''}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'string', false, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

MNcsiNCPortInfo.Type = TType

---@class MNcsiNCPortInfo.RxEnable
---@field RxEnable boolean
local TRxEnable = {}
TRxEnable.__index = TRxEnable
TRxEnable.group = {}

local function TRxEnable_from_obj(obj)
    return setmetatable(obj, TRxEnable)
end

function TRxEnable.new(RxEnable)
    return TRxEnable_from_obj({RxEnable = RxEnable})
end
---@param obj MNcsiNCPortInfo.RxEnable
function TRxEnable:init_from_obj(obj)
    self.RxEnable = obj.RxEnable
end

function TRxEnable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRxEnable.group)
end

TRxEnable.from_obj = TRxEnable_from_obj

TRxEnable.proto_property = {'RxEnable'}

TRxEnable.default = {false}

TRxEnable.struct = {{name = 'RxEnable', is_array = false, struct = nil}}

function TRxEnable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RxEnable', self.RxEnable, 'bool', false, errs, need_convert)

    TRxEnable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRxEnable.proto_property, errs, need_convert)
    return self
end

function TRxEnable:unpack(_)
    return self.RxEnable
end

MNcsiNCPortInfo.RxEnable = TRxEnable

---@class MNcsiNCPortInfo.LinkStatus
---@field LinkStatus string
local TLinkStatus = {}
TLinkStatus.__index = TLinkStatus
TLinkStatus.group = {}

local function TLinkStatus_from_obj(obj)
    return setmetatable(obj, TLinkStatus)
end

function TLinkStatus.new(LinkStatus)
    return TLinkStatus_from_obj({LinkStatus = LinkStatus})
end
---@param obj MNcsiNCPortInfo.LinkStatus
function TLinkStatus:init_from_obj(obj)
    self.LinkStatus = obj.LinkStatus
end

function TLinkStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkStatus.group)
end

TLinkStatus.from_obj = TLinkStatus_from_obj

TLinkStatus.proto_property = {'LinkStatus'}

TLinkStatus.default = {''}

TLinkStatus.struct = {{name = 'LinkStatus', is_array = false, struct = nil}}

function TLinkStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkStatus', self.LinkStatus, 'string', false, errs, need_convert)

    TLinkStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkStatus.proto_property, errs, need_convert)
    return self
end

function TLinkStatus:unpack(_)
    return self.LinkStatus
end

MNcsiNCPortInfo.LinkStatus = TLinkStatus

---@class MNcsiNCPortInfo.LinkStatusSrc
---@field LinkStatusSrc integer
local TLinkStatusSrc = {}
TLinkStatusSrc.__index = TLinkStatusSrc
TLinkStatusSrc.group = {}

local function TLinkStatusSrc_from_obj(obj)
    return setmetatable(obj, TLinkStatusSrc)
end

function TLinkStatusSrc.new(LinkStatusSrc)
    return TLinkStatusSrc_from_obj({LinkStatusSrc = LinkStatusSrc})
end
---@param obj MNcsiNCPortInfo.LinkStatusSrc
function TLinkStatusSrc:init_from_obj(obj)
    self.LinkStatusSrc = obj.LinkStatusSrc
end

function TLinkStatusSrc:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkStatusSrc.group)
end

TLinkStatusSrc.from_obj = TLinkStatusSrc_from_obj

TLinkStatusSrc.proto_property = {'LinkStatusSrc'}

TLinkStatusSrc.default = {0}

TLinkStatusSrc.struct = {{name = 'LinkStatusSrc', is_array = false, struct = nil}}

function TLinkStatusSrc:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkStatusSrc', self.LinkStatusSrc, 'uint8', false, errs, need_convert)

    TLinkStatusSrc:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkStatusSrc.proto_property, errs, need_convert)
    return self
end

function TLinkStatusSrc:unpack(_)
    return self.LinkStatusSrc
end

MNcsiNCPortInfo.LinkStatusSrc = TLinkStatusSrc

---@class MNcsiNCPortInfo.PortAvailable
---@field PortAvailable boolean
local TPortAvailable = {}
TPortAvailable.__index = TPortAvailable
TPortAvailable.group = {}

local function TPortAvailable_from_obj(obj)
    return setmetatable(obj, TPortAvailable)
end

function TPortAvailable.new(PortAvailable)
    return TPortAvailable_from_obj({PortAvailable = PortAvailable})
end
---@param obj MNcsiNCPortInfo.PortAvailable
function TPortAvailable:init_from_obj(obj)
    self.PortAvailable = obj.PortAvailable
end

function TPortAvailable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortAvailable.group)
end

TPortAvailable.from_obj = TPortAvailable_from_obj

TPortAvailable.proto_property = {'PortAvailable'}

TPortAvailable.default = {false}

TPortAvailable.struct = {{name = 'PortAvailable', is_array = false, struct = nil}}

function TPortAvailable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PortAvailable', self.PortAvailable, 'bool', false, errs, need_convert)

    TPortAvailable:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortAvailable.proto_property, errs, need_convert)
    return self
end

function TPortAvailable:unpack(_)
    return self.PortAvailable
end

MNcsiNCPortInfo.PortAvailable = TPortAvailable

---@class MNcsiNCPortInfo.ChannelId
---@field ChannelId integer
local TChannelId = {}
TChannelId.__index = TChannelId
TChannelId.group = {}

local function TChannelId_from_obj(obj)
    return setmetatable(obj, TChannelId)
end

function TChannelId.new(ChannelId)
    return TChannelId_from_obj({ChannelId = ChannelId})
end
---@param obj MNcsiNCPortInfo.ChannelId
function TChannelId:init_from_obj(obj)
    self.ChannelId = obj.ChannelId
end

function TChannelId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChannelId.group)
end

TChannelId.from_obj = TChannelId_from_obj

TChannelId.proto_property = {'ChannelId'}

TChannelId.default = {0}

TChannelId.struct = {{name = 'ChannelId', is_array = false, struct = nil}}

function TChannelId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ChannelId', self.ChannelId, 'uint8', false, errs, need_convert)

    TChannelId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChannelId.proto_property, errs, need_convert)
    return self
end

function TChannelId:unpack(_)
    return self.ChannelId
end

MNcsiNCPortInfo.ChannelId = TChannelId

---@class MNcsiNCPortInfo.PackageId
---@field PackageId integer
local TPackageId = {}
TPackageId.__index = TPackageId
TPackageId.group = {}

local function TPackageId_from_obj(obj)
    return setmetatable(obj, TPackageId)
end

function TPackageId.new(PackageId)
    return TPackageId_from_obj({PackageId = PackageId})
end
---@param obj MNcsiNCPortInfo.PackageId
function TPackageId:init_from_obj(obj)
    self.PackageId = obj.PackageId
end

function TPackageId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPackageId.group)
end

TPackageId.from_obj = TPackageId_from_obj

TPackageId.proto_property = {'PackageId'}

TPackageId.default = {0}

TPackageId.struct = {{name = 'PackageId', is_array = false, struct = nil}}

function TPackageId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PackageId', self.PackageId, 'uint8', false, errs, need_convert)

    TPackageId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPackageId.proto_property, errs, need_convert)
    return self
end

function TPackageId:unpack(_)
    return self.PackageId
end

MNcsiNCPortInfo.PackageId = TPackageId

---@class MNcsiNCPortInfo.PortId
---@field PortId integer
local TPortId = {}
TPortId.__index = TPortId
TPortId.group = {}

local function TPortId_from_obj(obj)
    return setmetatable(obj, TPortId)
end

function TPortId.new(PortId)
    return TPortId_from_obj({PortId = PortId})
end
---@param obj MNcsiNCPortInfo.PortId
function TPortId:init_from_obj(obj)
    self.PortId = obj.PortId
end

function TPortId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortId.group)
end

TPortId.from_obj = TPortId_from_obj

TPortId.proto_property = {'PortId'}

TPortId.default = {0}

TPortId.struct = {{name = 'PortId', is_array = false, struct = nil}}

function TPortId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'PortId', self.PortId, 'uint8', false, errs, need_convert)

    TPortId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortId.proto_property, errs, need_convert)
    return self
end

function TPortId:unpack(_)
    return self.PortId
end

MNcsiNCPortInfo.PortId = TPortId

---@class MNcsiNCPortInfo.NCId
---@field NCId integer
local TNCId = {}
TNCId.__index = TNCId
TNCId.group = {}

local function TNCId_from_obj(obj)
    return setmetatable(obj, TNCId)
end

function TNCId.new(NCId)
    return TNCId_from_obj({NCId = NCId})
end
---@param obj MNcsiNCPortInfo.NCId
function TNCId:init_from_obj(obj)
    self.NCId = obj.NCId
end

function TNCId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNCId.group)
end

TNCId.from_obj = TNCId_from_obj

TNCId.proto_property = {'NCId'}

TNCId.default = {0}

TNCId.struct = {{name = 'NCId', is_array = false, struct = nil}}

function TNCId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NCId', self.NCId, 'uint8', false, errs, need_convert)

    TNCId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNCId.proto_property, errs, need_convert)
    return self
end

function TNCId:unpack(_)
    return self.NCId
end

MNcsiNCPortInfo.NCId = TNCId

return MNcsiNCPortInfo
