-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local Units = {}

local Mdb = require 'mc.mdb'

---@class Unit: Table
---@field SystemID integer
---@field Slot integer
---@field Position integer
---@field Type string
---@field ComponentUID string
---@field Name string
---@field Manufacturer string
---@field Description string
---@field SerialNumber string
---@field PartNumber string
---@field PcbID integer
---@field PcbVersion string
---@field LogicVersion string
---@field HWSRVersion string
Units.Unit = Mdb.register_interface('bmc.kepler.Systems.Units.Unit', {
    SystemID = {'y', nil, true, nil},
    Slot = {'y', nil, true, nil},
    Position = {'y', nil, true, nil},
    Type = {'s', nil, true, nil},
    ComponentUID = {'s', nil, true, nil},
    Name = {'s', nil, true, nil},
    Manufacturer = {'s', nil, true, nil},
    Description = {'s', nil, true, nil},
    SerialNumber = {'s', nil, true, nil},
    PartNumber = {'s', nil, true, nil},
    PcbID = {'y', nil, true, nil},
    PcbVersion = {'s', nil, true, nil},
    LogicVersion = {'s', nil, true, nil},
    HWSRVersion = {'s', nil, true, nil}
}, {}, {})

---@class ICpuBoard: Table
---@field PowerStatus integer
---@field Power integer
Units.ICpuBoard = Mdb.register_interface('bmc.kepler.Systems.Units.CpuBoard', {
    PowerStatus = {'y', nil, false, nil},
    Power = {'q', nil, false, nil}
}, {}, {})

return Units
