-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class defs.ThresholdSensorItem
---@field SensorName string
---@field SensorUnit string
---@field SensorStatus string
---@field SensorReading string
---@field LowerThresholdFatal string
---@field LowerThresholdCritical string
---@field LowerThresholdNonCritical string
---@field UpperThresholdNonCritical string
---@field UpperThresholdCritical string
---@field UpperThresholdFatal string
local TThresholdSensorItem = {}
TThresholdSensorItem.__index = TThresholdSensorItem
TThresholdSensorItem.group = {}

local function TThresholdSensorItem_from_obj(obj)
    return setmetatable(obj, TThresholdSensorItem)
end

function TThresholdSensorItem.new(SensorName, SensorUnit, SensorStatus, SensorReading,
    LowerThresholdFatal, LowerThresholdCritical, LowerThresholdNonCritical,
    UpperThresholdNonCritical, UpperThresholdCritical, UpperThresholdFatal)
    return TThresholdSensorItem_from_obj({
        SensorName = SensorName,
        SensorUnit = SensorUnit,
        SensorStatus = SensorStatus,
        SensorReading = SensorReading,
        LowerThresholdFatal = LowerThresholdFatal,
        LowerThresholdCritical = LowerThresholdCritical,
        LowerThresholdNonCritical = LowerThresholdNonCritical,
        UpperThresholdNonCritical = UpperThresholdNonCritical,
        UpperThresholdCritical = UpperThresholdCritical,
        UpperThresholdFatal = UpperThresholdFatal
    })
end
---@param obj defs.ThresholdSensorItem
function TThresholdSensorItem:init_from_obj(obj)
    self.SensorName = obj.SensorName
    self.SensorUnit = obj.SensorUnit
    self.SensorStatus = obj.SensorStatus
    self.SensorReading = obj.SensorReading
    self.LowerThresholdFatal = obj.LowerThresholdFatal
    self.LowerThresholdCritical = obj.LowerThresholdCritical
    self.LowerThresholdNonCritical = obj.LowerThresholdNonCritical
    self.UpperThresholdNonCritical = obj.UpperThresholdNonCritical
    self.UpperThresholdCritical = obj.UpperThresholdCritical
    self.UpperThresholdFatal = obj.UpperThresholdFatal
end

function TThresholdSensorItem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TThresholdSensorItem.group)
end

TThresholdSensorItem.from_obj = TThresholdSensorItem_from_obj

TThresholdSensorItem.proto_property = {
    'SensorName', 'SensorUnit', 'SensorStatus', 'SensorReading', 'LowerThresholdFatal',
    'LowerThresholdCritical', 'LowerThresholdNonCritical', 'UpperThresholdNonCritical',
    'UpperThresholdCritical', 'UpperThresholdFatal'
}

TThresholdSensorItem.default = {'', '', '', '', '', '', '', '', '', ''}

TThresholdSensorItem.struct = {
    {name = 'SensorName', is_array = false, struct = nil},
    {name = 'SensorUnit', is_array = false, struct = nil},
    {name = 'SensorStatus', is_array = false, struct = nil},
    {name = 'SensorReading', is_array = false, struct = nil},
    {name = 'LowerThresholdFatal', is_array = false, struct = nil},
    {name = 'LowerThresholdCritical', is_array = false, struct = nil},
    {name = 'LowerThresholdNonCritical', is_array = false, struct = nil},
    {name = 'UpperThresholdNonCritical', is_array = false, struct = nil},
    {name = 'UpperThresholdCritical', is_array = false, struct = nil},
    {name = 'UpperThresholdFatal', is_array = false, struct = nil}
}

function TThresholdSensorItem:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SensorName', self.SensorName, 'string', false, errs)
    validate.Required(prefix .. 'SensorUnit', self.SensorUnit, 'string', false, errs)
    validate.Required(prefix .. 'SensorStatus', self.SensorStatus, 'string', false, errs)
    validate.Required(prefix .. 'SensorReading', self.SensorReading, 'string', false, errs)
    validate.Required(prefix .. 'LowerThresholdFatal', self.LowerThresholdFatal, 'string', false,
        errs)
    validate.Required(prefix .. 'LowerThresholdCritical', self.LowerThresholdCritical, 'string',
        false, errs)
    validate.Required(prefix .. 'LowerThresholdNonCritical', self.LowerThresholdNonCritical,
        'string', false, errs)
    validate.Required(prefix .. 'UpperThresholdNonCritical', self.UpperThresholdNonCritical,
        'string', false, errs)
    validate.Required(prefix .. 'UpperThresholdCritical', self.UpperThresholdCritical, 'string',
        false, errs)
    validate.Required(prefix .. 'UpperThresholdFatal', self.UpperThresholdFatal, 'string', false,
        errs)

    TThresholdSensorItem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TThresholdSensorItem.proto_property, errs)
    return self
end

function TThresholdSensorItem:unpack(_)
    return self.SensorName, self.SensorUnit, self.SensorStatus, self.SensorReading,
        self.LowerThresholdFatal, self.LowerThresholdCritical, self.LowerThresholdNonCritical,
        self.UpperThresholdNonCritical, self.UpperThresholdCritical, self.UpperThresholdFatal
end

defs.ThresholdSensorItem = TThresholdSensorItem

---@class ThresholdSensors.MockSensorRsp
local TMockSensorRsp = {}
TMockSensorRsp.__index = TMockSensorRsp
TMockSensorRsp.group = {}

local function TMockSensorRsp_from_obj(obj)
    return setmetatable(obj, TMockSensorRsp)
end

function TMockSensorRsp.new()
    return TMockSensorRsp_from_obj({})
end
---@param obj ThresholdSensors.MockSensorRsp
function TMockSensorRsp:init_from_obj(obj)

end

function TMockSensorRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMockSensorRsp.group)
end

TMockSensorRsp.from_obj = TMockSensorRsp_from_obj

TMockSensorRsp.proto_property = {}

TMockSensorRsp.default = {}

TMockSensorRsp.struct = {}

function TMockSensorRsp:validate(prefix, errs)
    prefix = prefix or ''

    TMockSensorRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMockSensorRsp.proto_property, errs)
    return self
end

function TMockSensorRsp:unpack(_)
end

msg.MockSensorRsp = TMockSensorRsp

---@class ThresholdSensors.MockSensorReq
---@field Enabled integer
---@field SensorName string
---@field Value string
local TMockSensorReq = {}
TMockSensorReq.__index = TMockSensorReq
TMockSensorReq.group = {}

local function TMockSensorReq_from_obj(obj)
    return setmetatable(obj, TMockSensorReq)
end

function TMockSensorReq.new(Enabled, SensorName, Value)
    return TMockSensorReq_from_obj({Enabled = Enabled, SensorName = SensorName, Value = Value})
end
---@param obj ThresholdSensors.MockSensorReq
function TMockSensorReq:init_from_obj(obj)
    self.Enabled = obj.Enabled
    self.SensorName = obj.SensorName
    self.Value = obj.Value
end

function TMockSensorReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMockSensorReq.group)
end

TMockSensorReq.from_obj = TMockSensorReq_from_obj

TMockSensorReq.proto_property = {'Enabled', 'SensorName', 'Value'}

TMockSensorReq.default = {0, '', ''}

TMockSensorReq.struct = {
    {name = 'Enabled', is_array = false, struct = nil},
    {name = 'SensorName', is_array = false, struct = nil},
    {name = 'Value', is_array = false, struct = nil}
}

function TMockSensorReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Enabled', self.Enabled, 'uint8', false, errs)
    validate.Required(prefix .. 'SensorName', self.SensorName, 'string', false, errs)
    validate.Required(prefix .. 'Value', self.Value, 'string', false, errs)

    validate.ranges(prefix .. 'Enabled', self.Enabled, 0, 1, errs)

    TMockSensorReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMockSensorReq.proto_property, errs)
    return self
end

function TMockSensorReq:unpack(_)
    return self.Enabled, self.SensorName, self.Value
end

msg.MockSensorReq = TMockSensorReq

---@class ThresholdSensors.GetThresholdSensorListRsp
---@field SensorList defs.ThresholdSensorItem[]
local TGetThresholdSensorListRsp = {}
TGetThresholdSensorListRsp.__index = TGetThresholdSensorListRsp
TGetThresholdSensorListRsp.group = {}

local function TGetThresholdSensorListRsp_from_obj(obj)
    obj.SensorList = utils.from_obj(defs.ThresholdSensorItem, obj.SensorList, true)
    return setmetatable(obj, TGetThresholdSensorListRsp)
end

function TGetThresholdSensorListRsp.new(SensorList)
    return TGetThresholdSensorListRsp_from_obj({SensorList = SensorList})
end
---@param obj ThresholdSensors.GetThresholdSensorListRsp
function TGetThresholdSensorListRsp:init_from_obj(obj)
    self.SensorList = obj.SensorList
end

function TGetThresholdSensorListRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetThresholdSensorListRsp.group)
end

TGetThresholdSensorListRsp.from_obj = TGetThresholdSensorListRsp_from_obj

TGetThresholdSensorListRsp.proto_property = {'SensorList'}

TGetThresholdSensorListRsp.default = {{}}

TGetThresholdSensorListRsp.struct = {
    {name = 'SensorList', is_array = true, struct = defs.ThresholdSensorItem.struct}
}

function TGetThresholdSensorListRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'SensorList', self.SensorList, 'defs.ThresholdSensorItem',
        false, errs)

    TGetThresholdSensorListRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetThresholdSensorListRsp.proto_property, errs)
    return self
end

function TGetThresholdSensorListRsp:unpack(raw)
    return utils.unpack(raw, self.SensorList, true)
end

msg.GetThresholdSensorListRsp = TGetThresholdSensorListRsp

---@class ThresholdSensors.GetThresholdSensorListReq
local TGetThresholdSensorListReq = {}
TGetThresholdSensorListReq.__index = TGetThresholdSensorListReq
TGetThresholdSensorListReq.group = {}

local function TGetThresholdSensorListReq_from_obj(obj)
    return setmetatable(obj, TGetThresholdSensorListReq)
end

function TGetThresholdSensorListReq.new()
    return TGetThresholdSensorListReq_from_obj({})
end
---@param obj ThresholdSensors.GetThresholdSensorListReq
function TGetThresholdSensorListReq:init_from_obj(obj)

end

function TGetThresholdSensorListReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetThresholdSensorListReq.group)
end

TGetThresholdSensorListReq.from_obj = TGetThresholdSensorListReq_from_obj

TGetThresholdSensorListReq.proto_property = {}

TGetThresholdSensorListReq.default = {}

TGetThresholdSensorListReq.struct = {}

function TGetThresholdSensorListReq:validate(prefix, errs)
    prefix = prefix or ''

    TGetThresholdSensorListReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetThresholdSensorListReq.proto_property, errs)
    return self
end

function TGetThresholdSensorListReq:unpack(_)
end

msg.GetThresholdSensorListReq = TGetThresholdSensorListReq

local ThresholdSensors = {}

local Mdb = require 'mc.mdb'

---@class ThresholdSensors: Table
ThresholdSensors.ThresholdSensors = Mdb.register_interface('bmc.kepler.Systems.ThresholdSensors',
    {}, {
        GetThresholdSensorList = {
            'a{ss}', 'a(ssssssssss)', msg.GetThresholdSensorListReq, msg.GetThresholdSensorListRsp
        },
        MockSensor = {'a{ss}yss', '', msg.MockSensorReq, msg.MockSensorRsp}
    }, {})
return ThresholdSensors
