-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local PowerControl = {}
 
local Mdb = require 'mc.mdb'
 
---@class IComputerSystemPowerControl: Table
---@field PowerOffTimeout integer
---@field PowerState string
---@field CurrentRestartCause string
---@field RestartCauseRecords string[]
---@field RestartCount integer
---@field PowerOnStrategy string
---@field PanelPowerButtonEnabled boolean
---@field HotswapState string
---@field FruType string
---@field SysResetDetected integer
PowerControl.IComputerSystemPowerControl = Mdb.register_interface('bmc.kepler.Systems.FruCtrl', {
    PowerOffTimeout = {'u', nil, false, nil},
    PowerState = {'s', nil, true, nil},
    CurrentRestartCause = {'s', nil, true, nil},
    RestartCauseRecords = {'as', nil, true, nil},
    RestartCount = {'y', nil, true, nil},
    PowerOnStrategy = {'s', nil, false, nil},
    PanelPowerButtonEnabled = {'b', nil, false, nil},
    HotswapState = {'s', nil, true, nil},
    FruType = {'s', nil, true, nil},
    SysResetDetected = {'y', nil, false, nil}
}, {}, {})
 
---@class IPowerControlPolicy: Table
---@field Mode string
---@field Seconds integer
PowerControl.IPowerControlPolicy = Mdb.register_interface('bmc.kepler.Systems.DelayedPowerOnPolicy',
    {Mode = {'s', nil, false, nil}, Seconds = {'y', nil, false, nil}}, {}, {})
 
---@class IPowerOnCriteria: Table
---@field PwrOnLocked boolean
---@field Reasons string[]
PowerControl.IPowerOnCriteria = Mdb.register_interface('bmc.kepler.Systems.PowerOnLock', {
    PwrOnLocked = {'b', nil, true, nil},
    Reasons = {'as', nil, true, nil}
}, {}, {})
 
---@class IComputerSystemPowerControlAccessor: Table
---@field PowerGDStatus integer
---@field ShortPushPowerButton integer
---@field LongPushPowerButton integer
---@field ACCycle integer
---@field NmiInterrupt integer
---@field ForceRestart integer
---@field PwrButtonLock integer
---@field PwrButtonEvt integer
PowerControl.IComputerSystemPowerControlAccessor = Mdb.register_interface(
    'bmc.kepler.mdb.PowerControlAccessor', {
        PowerGDStatus = {'y', nil, false, nil},
        ShortPushPowerButton = {'y', nil, false, nil},
        LongPushPowerButton = {'y', nil, false, nil},
        ACCycle = {'y', nil, false, nil},
        NmiInterrupt = {'y', nil, false, nil},
        ForceRestart = {'y', nil, false, nil},
        PwrButtonLock = {'y', nil, false, nil},
        PwrButtonEvt = {'y', nil, false, nil}
    }, {}, {})
 
return PowerControl