-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local PcieAddrInfo = {}

local Mdb = require 'mc.mdb'

---@class PcieAddrInfo: Table
---@field GroupID integer
---@field SlotID integer
---@field ComponentType integer
---@field ControllerIndex integer
---@field ControllerType integer
---@field SocketID integer
---@field Segment integer
---@field Bus integer
---@field Device integer
---@field Function integer
---@field VendorID integer
---@field DeviceID integer
PcieAddrInfo.PcieAddrInfo = Mdb.register_interface('bmc.kepler.Systems.PcieAddrInfo', {
    GroupID = {'y', nil, true, nil},
    SlotID = {'y', nil, true, nil},
    ComponentType = {'y', nil, true, nil},
    ControllerIndex = {'y', nil, true, nil},
    ControllerType = {'y', nil, true, nil},
    SocketID = {'y', nil, true, nil},
    Segment = {'y', nil, true, nil},
    Bus = {'y', nil, true, nil},
    Device = {'y', nil, true, nil},
    Function = {'y', nil, true, nil},
    VendorID = {'q', nil, true, nil},
    DeviceID = {'q', nil, true, nil}
}, {}, {})
return PcieAddrInfo
