-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local Memory = {}

local Mdb = require 'mc.mdb'

---@class Memory: Table
---@field SystemId integer
---@field Name string
---@field DimmName string
---@field Presence boolean
---@field CpuId integer
---@field NodeId integer
---@field ChannelId integer
---@field LogicalChannelId integer
---@field DimmId integer
---@field AllowedSpeedsMHz integer
---@field BaseModuleType string
---@field CapacityMiB integer
---@field DataWidthBits integer
---@field FirmwareRevision string
---@field Manufacturer string
---@field MemoryDeviceType string
---@field MemorySubsystemControllerManufacturerID string
---@field MemorySubsystemControllerProductID string
---@field MemoryType string
---@field OperatingSpeedMhz integer
---@field PartNumber string
---@field RankCount integer
---@field SerialNumber string
---@field MinVoltageMillivolt integer
---@field Position string
---@field DiagnosticFault integer
---@field PredictiveFault integer
Memory.Memory = Mdb.register_interface('bmc.kepler.Systems.Memory', {
    SystemId = {'y', nil, true, nil},
    Name = {'s', nil, true, nil},
    DimmName = {'s', nil, true, nil},
    Presence = {'b', nil, true, nil},
    CpuId = {'y', nil, true, nil},
    NodeId = {'y', nil, true, nil},
    ChannelId = {'y', nil, true, nil},
    LogicalChannelId = {'y', nil, true, nil},
    DimmId = {'y', nil, true, nil},
    AllowedSpeedsMHz = {'u', nil, true, nil},
    BaseModuleType = {'s', nil, true, nil},
    CapacityMiB = {'u', nil, true, nil},
    DataWidthBits = {'u', nil, true, nil},
    FirmwareRevision = {'s', nil, true, nil},
    Manufacturer = {'s', nil, true, nil},
    MemoryDeviceType = {'s', nil, true, nil},
    MemorySubsystemControllerManufacturerID = {'s', nil, true, nil},
    MemorySubsystemControllerProductID = {'s', nil, true, nil},
    MemoryType = {'s', nil, true, nil},
    OperatingSpeedMhz = {'u', nil, true, nil},
    PartNumber = {'s', nil, true, nil},
    RankCount = {'u', nil, true, nil},
    SerialNumber = {'s', nil, true, nil},
    MinVoltageMillivolt = {'u', nil, true, nil},
    Position = {'s', nil, true, nil},
    DiagnosticFault = {'y', nil, true, 0},
    PredictiveFault = {'y', nil, true, 0}
}, {}, {})
return Memory
