-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class FruCtrl.PowerCtrlRsp
---@field CmdResult integer
local TPowerCtrlRsp = {}
TPowerCtrlRsp.__index = TPowerCtrlRsp
TPowerCtrlRsp.group = {}

local function TPowerCtrlRsp_from_obj(obj)
    return setmetatable(obj, TPowerCtrlRsp)
end

function TPowerCtrlRsp.new(CmdResult)
    return TPowerCtrlRsp_from_obj({CmdResult = CmdResult})
end
---@param obj FruCtrl.PowerCtrlRsp
function TPowerCtrlRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TPowerCtrlRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCtrlRsp.group)
end

TPowerCtrlRsp.from_obj = TPowerCtrlRsp_from_obj

TPowerCtrlRsp.proto_property = {'CmdResult'}

TPowerCtrlRsp.default = {0}

TPowerCtrlRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TPowerCtrlRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'CmdResult', self.CmdResult, 'uint32', false, errs)

    TPowerCtrlRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCtrlRsp.proto_property, errs)
    return self
end

function TPowerCtrlRsp:unpack(_)
    return self.CmdResult
end

msg.PowerCtrlRsp = TPowerCtrlRsp

---@class FruCtrl.PowerCtrlReq
---@field PowerCtrlType string
---@field RestartCause string
local TPowerCtrlReq = {}
TPowerCtrlReq.__index = TPowerCtrlReq
TPowerCtrlReq.group = {}

local function TPowerCtrlReq_from_obj(obj)
    return setmetatable(obj, TPowerCtrlReq)
end

function TPowerCtrlReq.new(PowerCtrlType, RestartCause)
    return TPowerCtrlReq_from_obj({PowerCtrlType = PowerCtrlType, RestartCause = RestartCause})
end
---@param obj FruCtrl.PowerCtrlReq
function TPowerCtrlReq:init_from_obj(obj)
    self.PowerCtrlType = obj.PowerCtrlType
    self.RestartCause = obj.RestartCause
end

function TPowerCtrlReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCtrlReq.group)
end

TPowerCtrlReq.from_obj = TPowerCtrlReq_from_obj

TPowerCtrlReq.proto_property = {'PowerCtrlType', 'RestartCause'}

TPowerCtrlReq.default = {'', ''}

TPowerCtrlReq.struct = {
    {name = 'PowerCtrlType', is_array = false, struct = nil},
    {name = 'RestartCause', is_array = false, struct = nil}
}

function TPowerCtrlReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'PowerCtrlType', self.PowerCtrlType, 'string', false, errs)
    validate.Required(prefix .. 'RestartCause', self.RestartCause, 'string', false, errs)

    TPowerCtrlReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCtrlReq.proto_property, errs)
    return self
end

function TPowerCtrlReq:unpack(_)
    return self.PowerCtrlType, self.RestartCause
end

msg.PowerCtrlReq = TPowerCtrlReq

local FruCtrl = {}

local Mdb = require 'mc.mdb'

---@class FruCtrl: Table
---@field PowerState string
---@field SysResetDetected integer
---@field FruType string
---@field CurrentRestartCause string
---@field RestartCauseRecords string[]
---@field RestartCount integer
---@field PowerOnStrategy string
---@field PanelPowerButtonEnabled boolean
---@field PowerOffTimeout integer
---@field HotswapState string
FruCtrl.FruCtrl = Mdb.register_interface('bmc.kepler.Systems.FruCtrl', {
    PowerState = {'s', nil, true, nil},
    SysResetDetected = {'y', nil, true, nil},
    FruType = {'s', nil, true, nil},
    CurrentRestartCause = {'s', nil, true, nil},
    RestartCauseRecords = {'as', nil, true, nil},
    RestartCount = {'y', nil, true, nil},
    PowerOnStrategy = {'s', nil, false, nil},
    PanelPowerButtonEnabled = {'b', nil, false, nil},
    PowerOffTimeout = {'u', nil, false, nil},
    HotswapState = {'s', nil, true, nil}
}, {PowerCtrl = {'a{ss}ss', 'u', msg.PowerCtrlReq, msg.PowerCtrlRsp}}, {})
return FruCtrl
