-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local FanType = {}

local Mdb = require 'mc.mdb'

---@class FanType: Table
---@field Name string
---@field Index integer
---@field IsDefaultType boolean
---@field IsTwins boolean
---@field FrontMaxSpeed integer
---@field RearMaxSpeed integer
---@field IdentifyRangeLow integer
---@field IdentifyRangeHigh integer
---@field MatchedCount integer
---@field PartNumber string
---@field BOM string
---@field SystemId integer
FanType.FanType = Mdb.register_interface('bmc.kepler.Systems.FanType', {
    Name = {'s', nil, true, nil},
    Index = {'y', nil, true, nil},
    IsDefaultType = {'b', nil, true, nil},
    IsTwins = {'b', nil, true, nil},
    FrontMaxSpeed = {'u', nil, true, nil},
    RearMaxSpeed = {'u', nil, true, nil},
    IdentifyRangeLow = {'u', nil, true, nil},
    IdentifyRangeHigh = {'u', nil, true, nil},
    MatchedCount = {'y', nil, true, nil},
    PartNumber = {'s', nil, true, nil},
    BOM = {'s', nil, true, nil},
    SystemId = {'y', nil, true, nil}
}, {}, {})
return FanType
