-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class Debug.SetExceptionStatusRsp
---@field SysStatus integer
---@field ProcessorsStatus integer
local TSetExceptionStatusRsp = {}
TSetExceptionStatusRsp.__index = TSetExceptionStatusRsp
TSetExceptionStatusRsp.group = {}

local function TSetExceptionStatusRsp_from_obj(obj)
    return setmetatable(obj, TSetExceptionStatusRsp)
end

function TSetExceptionStatusRsp.new(SysStatus, ProcessorsStatus)
    return TSetExceptionStatusRsp_from_obj({
        SysStatus = SysStatus,
        ProcessorsStatus = ProcessorsStatus
    })
end
---@param obj Debug.SetExceptionStatusRsp
function TSetExceptionStatusRsp:init_from_obj(obj)
    self.SysStatus = obj.SysStatus
    self.ProcessorsStatus = obj.ProcessorsStatus
end

function TSetExceptionStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetExceptionStatusRsp.group)
end

TSetExceptionStatusRsp.from_obj = TSetExceptionStatusRsp_from_obj

TSetExceptionStatusRsp.proto_property = {'SysStatus', 'ProcessorsStatus'}

TSetExceptionStatusRsp.default = {0, 0}

TSetExceptionStatusRsp.struct = {
    {name = 'SysStatus', is_array = false, struct = nil},
    {name = 'ProcessorsStatus', is_array = false, struct = nil}
}

function TSetExceptionStatusRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SysStatus', self.SysStatus, 'uint32', false, errs)
    validate.Required(prefix .. 'ProcessorsStatus', self.ProcessorsStatus, 'uint64', false, errs)

    TSetExceptionStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetExceptionStatusRsp.proto_property, errs)
    return self
end

function TSetExceptionStatusRsp:unpack(_)
    return self.SysStatus, self.ProcessorsStatus
end

msg.SetExceptionStatusRsp = TSetExceptionStatusRsp

---@class Debug.SetExceptionStatusReq
---@field SysStatus integer
---@field ProcessorsStatus integer
local TSetExceptionStatusReq = {}
TSetExceptionStatusReq.__index = TSetExceptionStatusReq
TSetExceptionStatusReq.group = {}

local function TSetExceptionStatusReq_from_obj(obj)
    return setmetatable(obj, TSetExceptionStatusReq)
end

function TSetExceptionStatusReq.new(SysStatus, ProcessorsStatus)
    return TSetExceptionStatusReq_from_obj({
        SysStatus = SysStatus,
        ProcessorsStatus = ProcessorsStatus
    })
end
---@param obj Debug.SetExceptionStatusReq
function TSetExceptionStatusReq:init_from_obj(obj)
    self.SysStatus = obj.SysStatus
    self.ProcessorsStatus = obj.ProcessorsStatus
end

function TSetExceptionStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetExceptionStatusReq.group)
end

TSetExceptionStatusReq.from_obj = TSetExceptionStatusReq_from_obj

TSetExceptionStatusReq.proto_property = {'SysStatus', 'ProcessorsStatus'}

TSetExceptionStatusReq.default = {0, 0}

TSetExceptionStatusReq.struct = {
    {name = 'SysStatus', is_array = false, struct = nil},
    {name = 'ProcessorsStatus', is_array = false, struct = nil}
}

function TSetExceptionStatusReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SysStatus', self.SysStatus, 'uint32', false, errs)
    validate.Required(prefix .. 'ProcessorsStatus', self.ProcessorsStatus, 'uint64', false, errs)

    TSetExceptionStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetExceptionStatusReq.proto_property, errs)
    return self
end

function TSetExceptionStatusReq:unpack(_)
    return self.SysStatus, self.ProcessorsStatus
end

msg.SetExceptionStatusReq = TSetExceptionStatusReq

---@class Debug.SetStateMachineRsp
---@field Ret integer
---@field ErrorInfo string
local TSetStateMachineRsp = {}
TSetStateMachineRsp.__index = TSetStateMachineRsp
TSetStateMachineRsp.group = {}

local function TSetStateMachineRsp_from_obj(obj)
    return setmetatable(obj, TSetStateMachineRsp)
end

function TSetStateMachineRsp.new(Ret, ErrorInfo)
    return TSetStateMachineRsp_from_obj({Ret = Ret, ErrorInfo = ErrorInfo})
end
---@param obj Debug.SetStateMachineRsp
function TSetStateMachineRsp:init_from_obj(obj)
    self.Ret = obj.Ret
    self.ErrorInfo = obj.ErrorInfo
end

function TSetStateMachineRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStateMachineRsp.group)
end

TSetStateMachineRsp.from_obj = TSetStateMachineRsp_from_obj

TSetStateMachineRsp.proto_property = {'Ret', 'ErrorInfo'}

TSetStateMachineRsp.default = {0, ''}

TSetStateMachineRsp.struct = {
    {name = 'Ret', is_array = false, struct = nil},
    {name = 'ErrorInfo', is_array = false, struct = nil}
}

function TSetStateMachineRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Ret', self.Ret, 'int32', false, errs)
    validate.Required(prefix .. 'ErrorInfo', self.ErrorInfo, 'string', false, errs)

    TSetStateMachineRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStateMachineRsp.proto_property, errs)
    return self
end

function TSetStateMachineRsp:unpack(_)
    return self.Ret, self.ErrorInfo
end

msg.SetStateMachineRsp = TSetStateMachineRsp

---@class Debug.SetStateMachineReq
---@field Parm integer[]
local TSetStateMachineReq = {}
TSetStateMachineReq.__index = TSetStateMachineReq
TSetStateMachineReq.group = {}

local function TSetStateMachineReq_from_obj(obj)
    return setmetatable(obj, TSetStateMachineReq)
end

function TSetStateMachineReq.new(Parm)
    return TSetStateMachineReq_from_obj({Parm = Parm})
end
---@param obj Debug.SetStateMachineReq
function TSetStateMachineReq:init_from_obj(obj)
    self.Parm = obj.Parm
end

function TSetStateMachineReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetStateMachineReq.group)
end

TSetStateMachineReq.from_obj = TSetStateMachineReq_from_obj

TSetStateMachineReq.proto_property = {'Parm'}

TSetStateMachineReq.default = {{}}

TSetStateMachineReq.struct = {{name = 'Parm', is_array = true, struct = nil}}

function TSetStateMachineReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'Parm', self.Parm, 'uint8', false, errs)

    TSetStateMachineReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetStateMachineReq.proto_property, errs)
    return self
end

function TSetStateMachineReq:unpack(_)
    return self.Parm
end

msg.SetStateMachineReq = TSetStateMachineReq

local Debug = {}

local Mdb = require 'mc.mdb'

---@class Debug: Table
Debug.Debug = Mdb.register_interface('bmc.kepler.Systems.ExceptionInfo.Debug', {}, {
    SetStateMachine = {'a{ss}ay', 'is', msg.SetStateMachineReq, msg.SetStateMachineRsp},
    SetExceptionStatus = {'a{ss}ut', 'ut', msg.SetExceptionStatusReq, msg.SetExceptionStatusRsp}
}, {})
return Debug
