-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class CoolingPolicy.SetCustomCoolingPolicyReq
---@field TemperatureArray integer[]
---@field FanSpeedArray integer[]
local TSetCustomCoolingPolicyReq = {}
TSetCustomCoolingPolicyReq.__index = TSetCustomCoolingPolicyReq
TSetCustomCoolingPolicyReq.group = {}

local function TSetCustomCoolingPolicyReq_from_obj(obj)
    return setmetatable(obj, TSetCustomCoolingPolicyReq)
end

function TSetCustomCoolingPolicyReq.new(TemperatureArray, FanSpeedArray)
    return TSetCustomCoolingPolicyReq_from_obj({
        TemperatureArray = TemperatureArray,
        FanSpeedArray = FanSpeedArray
    })
end
---@param obj CoolingPolicy.SetCustomCoolingPolicyReq
function TSetCustomCoolingPolicyReq:init_from_obj(obj)
    self.TemperatureArray = obj.TemperatureArray
    self.FanSpeedArray = obj.FanSpeedArray
end

function TSetCustomCoolingPolicyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCustomCoolingPolicyReq.group)
end

TSetCustomCoolingPolicyReq.from_obj = TSetCustomCoolingPolicyReq_from_obj

TSetCustomCoolingPolicyReq.proto_property = {'TemperatureArray', 'FanSpeedArray'}

TSetCustomCoolingPolicyReq.default = {{}, {}}

TSetCustomCoolingPolicyReq.struct = {
    {name = 'TemperatureArray', is_array = true, struct = nil},
    {name = 'FanSpeedArray', is_array = true, struct = nil}
}

function TSetCustomCoolingPolicyReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'TemperatureArray', self.TemperatureArray, 'uint8', false, errs)
    validate.OptionalArray(prefix .. 'FanSpeedArray', self.FanSpeedArray, 'uint8', false, errs)

    if self.TemperatureArray ~= nil then
    end
    if self.FanSpeedArray ~= nil then
    end

    TSetCustomCoolingPolicyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCustomCoolingPolicyReq.proto_property, errs)
    return self
end

function TSetCustomCoolingPolicyReq:unpack(_)
    return self.TemperatureArray, self.FanSpeedArray
end

msg.SetCustomCoolingPolicyReq = TSetCustomCoolingPolicyReq

local CoolingPolicy = {}

local Mdb = require 'mc.mdb'

---@class CoolingPolicy: Table
---@field PolicyIdx integer
---@field PolicyType integer
---@field IsValid integer
---@field ExpCondVal string
---@field ActualCondVal string
---@field CustomSupported boolean
---@field FanSpeedRangePercents integer[]
---@field TemperatureRangeLow integer[]
---@field TemperatureRangeHigh integer[]
---@field SpeedRangeLow integer[]
---@field SpeedRangeHigh integer[]
CoolingPolicy.CoolingPolicy = Mdb.register_interface('bmc.kepler.Systems.CoolingPolicy', {
    PolicyIdx = {'y', nil, true, nil},
    PolicyType = {'u', nil, true, nil},
    IsValid = {'y', nil, true, nil},
    ExpCondVal = {'s', nil, false, nil},
    ActualCondVal = {'s', nil, true, nil},
    CustomSupported = {'b', nil, false, False},
    FanSpeedRangePercents = {'ay', nil, false, nil},
    TemperatureRangeLow = {'an', nil, false, nil},
    TemperatureRangeHigh = {'an', nil, false, nil},
    SpeedRangeLow = {'an', nil, false, nil},
    SpeedRangeHigh = {'an', nil, false, nil}
}, {SetCustomCoolingPolicy = {'a{ss}ayay', '', msg.SetCustomCoolingPolicyReq, nil}}, {})
return CoolingPolicy
