-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local ObjectManage = {}

local Mdb = require 'mc.mdb'

local ObjectManageMsg = require 'mdb.bmc.kepler.ObjectManage.types.message'

---@class IObjectManage: Table
ObjectManage.IObjectManage = Mdb.register_interface('bmc.kepler.ObjectManage', {}, {
    AddObject = {'a{ss}sssss', '', ObjectManageMsg.AddObjectReq, nil},
    DeleteObject = {'a{ss}sss', '', ObjectManageMsg.DeleteObjectReq, nil},
    AddObjectComplete = {'a{ss}s', '', ObjectManageMsg.AddObjectCompleteReq, nil},
    DeleteObjectComplete = {'a{ss}s', '', ObjectManageMsg.DeleteObjectCompleteReq, nil}
}, {})

return ObjectManage
