-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local RemoteConsoleMsg = {}

---@class RemoteConsoleMsg.SetPersisUSBConnEnabledReq
---@field Enabled boolean
local TSetPersisUSBConnEnabledReq = {}
TSetPersisUSBConnEnabledReq.__index = TSetPersisUSBConnEnabledReq
TSetPersisUSBConnEnabledReq.group = {}

local function TSetPersisUSBConnEnabledReq_from_obj(obj)
    return setmetatable(obj, TSetPersisUSBConnEnabledReq)
end

function TSetPersisUSBConnEnabledReq.new(Enabled)
    return TSetPersisUSBConnEnabledReq_from_obj({Enabled = Enabled})
end
---@param obj RemoteConsoleMsg.SetPersisUSBConnEnabledReq
function TSetPersisUSBConnEnabledReq:init_from_obj(obj)
    self.Enabled = obj.Enabled
end

function TSetPersisUSBConnEnabledReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPersisUSBConnEnabledReq.group)
end

TSetPersisUSBConnEnabledReq.from_obj = TSetPersisUSBConnEnabledReq_from_obj

TSetPersisUSBConnEnabledReq.proto_property = {'Enabled'}

TSetPersisUSBConnEnabledReq.default = {false}

TSetPersisUSBConnEnabledReq.struct = {{name = 'Enabled', is_array = false, struct = nil}}

function TSetPersisUSBConnEnabledReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Enabled', self.Enabled, 'bool', false, errs)

    TSetPersisUSBConnEnabledReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPersisUSBConnEnabledReq.proto_property, errs)
    return self
end

function TSetPersisUSBConnEnabledReq:unpack(_)
    return self.Enabled
end

RemoteConsoleMsg.SetPersisUSBConnEnabledReq = TSetPersisUSBConnEnabledReq

---@class RemoteConsoleMsg.SetPersisUSBConnEnabledRsp
---@field Result integer
local TSetPersisUSBConnEnabledRsp = {}
TSetPersisUSBConnEnabledRsp.__index = TSetPersisUSBConnEnabledRsp
TSetPersisUSBConnEnabledRsp.group = {}

local function TSetPersisUSBConnEnabledRsp_from_obj(obj)
    return setmetatable(obj, TSetPersisUSBConnEnabledRsp)
end

function TSetPersisUSBConnEnabledRsp.new(Result)
    return TSetPersisUSBConnEnabledRsp_from_obj({Result = Result})
end
---@param obj RemoteConsoleMsg.SetPersisUSBConnEnabledRsp
function TSetPersisUSBConnEnabledRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetPersisUSBConnEnabledRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPersisUSBConnEnabledRsp.group)
end

TSetPersisUSBConnEnabledRsp.from_obj = TSetPersisUSBConnEnabledRsp_from_obj

TSetPersisUSBConnEnabledRsp.proto_property = {'Result'}

TSetPersisUSBConnEnabledRsp.default = {0}

TSetPersisUSBConnEnabledRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetPersisUSBConnEnabledRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Result', self.Result, 'int32', false, errs)

    TSetPersisUSBConnEnabledRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPersisUSBConnEnabledRsp.proto_property, errs)
    return self
end

function TSetPersisUSBConnEnabledRsp:unpack(_)
    return self.Result
end

RemoteConsoleMsg.SetPersisUSBConnEnabledRsp = TSetPersisUSBConnEnabledRsp

---@class RemoteConsoleMsg.UsbConnectRsp
---@field UsbId integer
---@field FuncId integer
local TUsbConnectRsp = {}
TUsbConnectRsp.__index = TUsbConnectRsp
TUsbConnectRsp.group = {}

local function TUsbConnectRsp_from_obj(obj)
    return setmetatable(obj, TUsbConnectRsp)
end

function TUsbConnectRsp.new(UsbId, FuncId)
    return TUsbConnectRsp_from_obj({UsbId = UsbId, FuncId = FuncId})
end
---@param obj RemoteConsoleMsg.UsbConnectRsp
function TUsbConnectRsp:init_from_obj(obj)
    self.UsbId = obj.UsbId
    self.FuncId = obj.FuncId
end

function TUsbConnectRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUsbConnectRsp.group)
end

TUsbConnectRsp.from_obj = TUsbConnectRsp_from_obj

TUsbConnectRsp.proto_property = {'UsbId', 'FuncId'}

TUsbConnectRsp.default = {0, 0}

TUsbConnectRsp.struct = {
    {name = 'UsbId', is_array = false, struct = nil},
    {name = 'FuncId', is_array = false, struct = nil}
}

function TUsbConnectRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'UsbId', self.UsbId, 'uint32', false, errs)
    validate.Required(prefix .. 'FuncId', self.FuncId, 'uint32', false, errs)

    TUsbConnectRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUsbConnectRsp.proto_property, errs)
    return self
end

function TUsbConnectRsp:unpack(_)
    return self.UsbId, self.FuncId
end

RemoteConsoleMsg.UsbConnectRsp = TUsbConnectRsp

---@class RemoteConsoleMsg.UsbKeyMouseConnectRsp
---@field KeyUsbId integer
---@field KeyFuncId integer
---@field MouseUsbId integer
---@field MouseFuncId integer
local TUsbKeyMouseConnectRsp = {}
TUsbKeyMouseConnectRsp.__index = TUsbKeyMouseConnectRsp
TUsbKeyMouseConnectRsp.group = {}

local function TUsbKeyMouseConnectRsp_from_obj(obj)
    return setmetatable(obj, TUsbKeyMouseConnectRsp)
end

function TUsbKeyMouseConnectRsp.new(KeyUsbId, KeyFuncId, MouseUsbId, MouseFuncId)
    return TUsbKeyMouseConnectRsp_from_obj({
        KeyUsbId = KeyUsbId,
        KeyFuncId = KeyFuncId,
        MouseUsbId = MouseUsbId,
        MouseFuncId = MouseFuncId
    })
end
---@param obj RemoteConsoleMsg.UsbKeyMouseConnectRsp
function TUsbKeyMouseConnectRsp:init_from_obj(obj)
    self.KeyUsbId = obj.KeyUsbId
    self.KeyFuncId = obj.KeyFuncId
    self.MouseUsbId = obj.MouseUsbId
    self.MouseFuncId = obj.MouseFuncId
end

function TUsbKeyMouseConnectRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUsbKeyMouseConnectRsp.group)
end

TUsbKeyMouseConnectRsp.from_obj = TUsbKeyMouseConnectRsp_from_obj

TUsbKeyMouseConnectRsp.proto_property = {'KeyUsbId', 'KeyFuncId', 'MouseUsbId', 'MouseFuncId'}

TUsbKeyMouseConnectRsp.default = {0, 0, 0, 0}

TUsbKeyMouseConnectRsp.struct = {
    {name = 'KeyUsbId', is_array = false, struct = nil},
    {name = 'KeyFuncId', is_array = false, struct = nil},
    {name = 'MouseUsbId', is_array = false, struct = nil},
    {name = 'MouseFuncId', is_array = false, struct = nil}
}

function TUsbKeyMouseConnectRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'KeyUsbId', self.KeyUsbId, 'uint32', false, errs)
    validate.Required(prefix .. 'KeyFuncId', self.KeyFuncId, 'uint32', false, errs)
    validate.Required(prefix .. 'MouseUsbId', self.MouseUsbId, 'uint32', false, errs)
    validate.Required(prefix .. 'MouseFuncId', self.MouseFuncId, 'uint32', false, errs)

    TUsbKeyMouseConnectRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUsbKeyMouseConnectRsp.proto_property, errs)
    return self
end

function TUsbKeyMouseConnectRsp:unpack(_)
    return self.KeyUsbId, self.KeyFuncId, self.MouseUsbId, self.MouseFuncId
end

RemoteConsoleMsg.UsbKeyMouseConnectRsp = TUsbKeyMouseConnectRsp

---@class RemoteConsoleMsg.InsertMediaReq
---@field Image string
local TInsertMediaReq = {}
TInsertMediaReq.__index = TInsertMediaReq
TInsertMediaReq.group = {}

local function TInsertMediaReq_from_obj(obj)
    return setmetatable(obj, TInsertMediaReq)
end

function TInsertMediaReq.new(Image)
    return TInsertMediaReq_from_obj({Image = Image})
end
---@param obj RemoteConsoleMsg.InsertMediaReq
function TInsertMediaReq:init_from_obj(obj)
    self.Image = obj.Image
end

function TInsertMediaReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInsertMediaReq.group)
end

TInsertMediaReq.from_obj = TInsertMediaReq_from_obj

TInsertMediaReq.proto_property = {'Image'}

TInsertMediaReq.default = {''}

TInsertMediaReq.struct = {{name = 'Image', is_array = false, struct = nil}}

function TInsertMediaReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Image', self.Image, 'string', false, errs)

    TInsertMediaReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInsertMediaReq.proto_property, errs)
    return self
end

function TInsertMediaReq:unpack(_)
    return self.Image
end

RemoteConsoleMsg.InsertMediaReq = TInsertMediaReq

---@class RemoteConsoleMsg.InsertMediaRsp
---@field Result integer
local TInsertMediaRsp = {}
TInsertMediaRsp.__index = TInsertMediaRsp
TInsertMediaRsp.group = {}

local function TInsertMediaRsp_from_obj(obj)
    return setmetatable(obj, TInsertMediaRsp)
end

function TInsertMediaRsp.new(Result)
    return TInsertMediaRsp_from_obj({Result = Result})
end
---@param obj RemoteConsoleMsg.InsertMediaRsp
function TInsertMediaRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TInsertMediaRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInsertMediaRsp.group)
end

TInsertMediaRsp.from_obj = TInsertMediaRsp_from_obj

TInsertMediaRsp.proto_property = {'Result'}

TInsertMediaRsp.default = {0}

TInsertMediaRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TInsertMediaRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Result', self.Result, 'int32', false, errs)

    TInsertMediaRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInsertMediaRsp.proto_property, errs)
    return self
end

function TInsertMediaRsp:unpack(_)
    return self.Result
end

RemoteConsoleMsg.InsertMediaRsp = TInsertMediaRsp

---@class RemoteConsoleMsg.EjectMediaReq
local TEjectMediaReq = {}
TEjectMediaReq.__index = TEjectMediaReq
TEjectMediaReq.group = {}

local function TEjectMediaReq_from_obj(obj)
    return setmetatable(obj, TEjectMediaReq)
end

function TEjectMediaReq.new()
    return TEjectMediaReq_from_obj({})
end
---@param obj RemoteConsoleMsg.EjectMediaReq
function TEjectMediaReq:init_from_obj(obj)

end

function TEjectMediaReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEjectMediaReq.group)
end

TEjectMediaReq.from_obj = TEjectMediaReq_from_obj

TEjectMediaReq.proto_property = {}

TEjectMediaReq.default = {}

TEjectMediaReq.struct = {}

function TEjectMediaReq:validate(prefix, errs)
    prefix = prefix or ''

    TEjectMediaReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEjectMediaReq.proto_property, errs)
    return self
end

function TEjectMediaReq:unpack(_)
end

RemoteConsoleMsg.EjectMediaReq = TEjectMediaReq

---@class RemoteConsoleMsg.EjectMediaRsp
---@field Result integer
local TEjectMediaRsp = {}
TEjectMediaRsp.__index = TEjectMediaRsp
TEjectMediaRsp.group = {}

local function TEjectMediaRsp_from_obj(obj)
    return setmetatable(obj, TEjectMediaRsp)
end

function TEjectMediaRsp.new(Result)
    return TEjectMediaRsp_from_obj({Result = Result})
end
---@param obj RemoteConsoleMsg.EjectMediaRsp
function TEjectMediaRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TEjectMediaRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEjectMediaRsp.group)
end

TEjectMediaRsp.from_obj = TEjectMediaRsp_from_obj

TEjectMediaRsp.proto_property = {'Result'}

TEjectMediaRsp.default = {0}

TEjectMediaRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TEjectMediaRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Result', self.Result, 'int32', false, errs)

    TEjectMediaRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEjectMediaRsp.proto_property, errs)
    return self
end

function TEjectMediaRsp:unpack(_)
    return self.Result
end

RemoteConsoleMsg.EjectMediaRsp = TEjectMediaRsp

return RemoteConsoleMsg
