-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class defs.AlgorithmsStateItem
---@field Name string
---@field Enabled boolean
local TAlgorithmsStateItem = {}
TAlgorithmsStateItem.__index = TAlgorithmsStateItem
TAlgorithmsStateItem.group = {}

local function TAlgorithmsStateItem_from_obj(obj)
    return setmetatable(obj, TAlgorithmsStateItem)
end

function TAlgorithmsStateItem.new(Name, Enabled)
    return TAlgorithmsStateItem_from_obj({Name = Name, Enabled = Enabled})
end
---@param obj defs.AlgorithmsStateItem
function TAlgorithmsStateItem:init_from_obj(obj)
    self.Name = obj.Name
    self.Enabled = obj.Enabled
end

function TAlgorithmsStateItem:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAlgorithmsStateItem.group)
end

TAlgorithmsStateItem.from_obj = TAlgorithmsStateItem_from_obj

TAlgorithmsStateItem.proto_property = {'Name', 'Enabled'}

TAlgorithmsStateItem.default = {'', false}

TAlgorithmsStateItem.struct = {
    {name = 'Name', is_array = false, struct = nil},
    {name = 'Enabled', is_array = false, struct = nil}
}

function TAlgorithmsStateItem:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Name', self.Name, 'string', false, errs)
    validate.Required(prefix .. 'Enabled', self.Enabled, 'bool', false, errs)

    TAlgorithmsStateItem:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAlgorithmsStateItem.proto_property, errs)
    return self
end

function TAlgorithmsStateItem:unpack(_)
    return self.Name, self.Enabled
end

defs.AlgorithmsStateItem = TAlgorithmsStateItem

---@class SSHAlgorithms.SetAlgorithmsStateRsp
local TSetAlgorithmsStateRsp = {}
TSetAlgorithmsStateRsp.__index = TSetAlgorithmsStateRsp
TSetAlgorithmsStateRsp.group = {}

local function TSetAlgorithmsStateRsp_from_obj(obj)
    return setmetatable(obj, TSetAlgorithmsStateRsp)
end

function TSetAlgorithmsStateRsp.new()
    return TSetAlgorithmsStateRsp_from_obj({})
end
---@param obj SSHAlgorithms.SetAlgorithmsStateRsp
function TSetAlgorithmsStateRsp:init_from_obj(obj)

end

function TSetAlgorithmsStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAlgorithmsStateRsp.group)
end

TSetAlgorithmsStateRsp.from_obj = TSetAlgorithmsStateRsp_from_obj

TSetAlgorithmsStateRsp.proto_property = {}

TSetAlgorithmsStateRsp.default = {}

TSetAlgorithmsStateRsp.struct = {}

function TSetAlgorithmsStateRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSetAlgorithmsStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAlgorithmsStateRsp.proto_property, errs)
    return self
end

function TSetAlgorithmsStateRsp:unpack(_)
end

msg.SetAlgorithmsStateRsp = TSetAlgorithmsStateRsp

---@class SSHAlgorithms.SetAlgorithmsStateReq
---@field AlgorithmsState defs.AlgorithmsStateItem[]
local TSetAlgorithmsStateReq = {}
TSetAlgorithmsStateReq.__index = TSetAlgorithmsStateReq
TSetAlgorithmsStateReq.group = {}

local function TSetAlgorithmsStateReq_from_obj(obj)
    obj.AlgorithmsState = utils.from_obj(defs.AlgorithmsStateItem, obj.AlgorithmsState, true)
    return setmetatable(obj, TSetAlgorithmsStateReq)
end

function TSetAlgorithmsStateReq.new(AlgorithmsState)
    return TSetAlgorithmsStateReq_from_obj({AlgorithmsState = AlgorithmsState})
end
---@param obj SSHAlgorithms.SetAlgorithmsStateReq
function TSetAlgorithmsStateReq:init_from_obj(obj)
    self.AlgorithmsState = obj.AlgorithmsState
end

function TSetAlgorithmsStateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetAlgorithmsStateReq.group)
end

TSetAlgorithmsStateReq.from_obj = TSetAlgorithmsStateReq_from_obj

TSetAlgorithmsStateReq.proto_property = {'AlgorithmsState'}

TSetAlgorithmsStateReq.default = {{}}

TSetAlgorithmsStateReq.struct = {
    {name = 'AlgorithmsState', is_array = true, struct = defs.AlgorithmsStateItem.struct}
}

function TSetAlgorithmsStateReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'AlgorithmsState', self.AlgorithmsState,
        'defs.AlgorithmsStateItem', false, errs)

    TSetAlgorithmsStateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetAlgorithmsStateReq.proto_property, errs)
    return self
end

function TSetAlgorithmsStateReq:unpack(raw)
    return utils.unpack(raw, self.AlgorithmsState, true)
end

msg.SetAlgorithmsStateReq = TSetAlgorithmsStateReq

local SSHAlgorithms = {}

local Mdb = require 'mc.mdb'

---@class SSHAlgorithms: Table
SSHAlgorithms.SSHAlgorithms = Mdb.register_interface('bmc.kepler.Managers.Security.SSHAlgorithms',
    {}, {
        SetAlgorithmsState = {
            'a{ss}a(sb)', '', msg.SetAlgorithmsStateReq, msg.SetAlgorithmsStateRsp
        }
    }, {})
return SSHAlgorithms
