-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class ManagementTopology.GetRsp
---@field Topology string
local TGetRsp = {}
TGetRsp.__index = TGetRsp
TGetRsp.group = {}

local function TGetRsp_from_obj(obj)
    return setmetatable(obj, TGetRsp)
end

function TGetRsp.new(Topology)
    return TGetRsp_from_obj({Topology = Topology})
end
---@param obj ManagementTopology.GetRsp
function TGetRsp:init_from_obj(obj)
    self.Topology = obj.Topology
end

function TGetRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetRsp.group)
end

TGetRsp.from_obj = TGetRsp_from_obj

TGetRsp.proto_property = {'Topology'}

TGetRsp.default = {''}

TGetRsp.struct = {{name = 'Topology', is_array = false, struct = nil}}

function TGetRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Topology', self.Topology, 'string', false, errs)

    TGetRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetRsp.proto_property, errs)
    return self
end

function TGetRsp:unpack(_)
    return self.Topology
end

msg.GetRsp = TGetRsp

---@class ManagementTopology.GetReq
local TGetReq = {}
TGetReq.__index = TGetReq
TGetReq.group = {}

local function TGetReq_from_obj(obj)
    return setmetatable(obj, TGetReq)
end

function TGetReq.new()
    return TGetReq_from_obj({})
end
---@param obj ManagementTopology.GetReq
function TGetReq:init_from_obj(obj)

end

function TGetReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetReq.group)
end

TGetReq.from_obj = TGetReq_from_obj

TGetReq.proto_property = {}

TGetReq.default = {}

TGetReq.struct = {}

function TGetReq:validate(prefix, errs)
    prefix = prefix or ''

    TGetReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetReq.proto_property, errs)
    return self
end

function TGetReq:unpack(_)
end

msg.GetReq = TGetReq

local ManagementTopology = {}

local Mdb = require 'mc.mdb'

---@class ManagementTopology: Table
---@field Position string
ManagementTopology.ManagementTopology = Mdb.register_interface('bmc.kepler.ManagementTopology',
    {Position = {'s', nil, true, nil}}, {Get = {'a{ss}', 's', msg.GetReq, msg.GetRsp}}, {})
return ManagementTopology
