-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class LicenseService.RevokeRsp
---@field RevokeTicket string
local TRevokeRsp = {}
TRevokeRsp.__index = TRevokeRsp
TRevokeRsp.group = {}

local function TRevokeRsp_from_obj(obj)
    return setmetatable(obj, TRevokeRsp)
end

function TRevokeRsp.new(RevokeTicket)
    return TRevokeRsp_from_obj({RevokeTicket = RevokeTicket})
end
---@param obj LicenseService.RevokeRsp
function TRevokeRsp:init_from_obj(obj)
    self.RevokeTicket = obj.RevokeTicket
end

function TRevokeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRevokeRsp.group)
end

TRevokeRsp.from_obj = TRevokeRsp_from_obj

TRevokeRsp.proto_property = {'RevokeTicket'}

TRevokeRsp.default = {''}

TRevokeRsp.struct = {{name = 'RevokeTicket', is_array = false, struct = nil}}

function TRevokeRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'RevokeTicket', self.RevokeTicket, 'string', false, errs)

    TRevokeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRevokeRsp.proto_property, errs)
    return self
end

function TRevokeRsp:unpack(_)
    return self.RevokeTicket
end

msg.RevokeRsp = TRevokeRsp

---@class LicenseService.RevokeReq
---@field LicenseId string
local TRevokeReq = {}
TRevokeReq.__index = TRevokeReq
TRevokeReq.group = {}

local function TRevokeReq_from_obj(obj)
    return setmetatable(obj, TRevokeReq)
end

function TRevokeReq.new(LicenseId)
    return TRevokeReq_from_obj({LicenseId = LicenseId})
end
---@param obj LicenseService.RevokeReq
function TRevokeReq:init_from_obj(obj)
    self.LicenseId = obj.LicenseId
end

function TRevokeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRevokeReq.group)
end

TRevokeReq.from_obj = TRevokeReq_from_obj

TRevokeReq.proto_property = {'LicenseId'}

TRevokeReq.default = {''}

TRevokeReq.struct = {{name = 'LicenseId', is_array = false, struct = nil}}

function TRevokeReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'LicenseId', self.LicenseId, 'string', false, errs)

    TRevokeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRevokeReq.proto_property, errs)
    return self
end

function TRevokeReq:unpack(_)
    return self.LicenseId
end

msg.RevokeReq = TRevokeReq

---@class LicenseService.DeleteRsp
local TDeleteRsp = {}
TDeleteRsp.__index = TDeleteRsp
TDeleteRsp.group = {}

local function TDeleteRsp_from_obj(obj)
    return setmetatable(obj, TDeleteRsp)
end

function TDeleteRsp.new()
    return TDeleteRsp_from_obj({})
end
---@param obj LicenseService.DeleteRsp
function TDeleteRsp:init_from_obj(obj)

end

function TDeleteRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteRsp.group)
end

TDeleteRsp.from_obj = TDeleteRsp_from_obj

TDeleteRsp.proto_property = {}

TDeleteRsp.default = {}

TDeleteRsp.struct = {}

function TDeleteRsp:validate(prefix, errs)
    prefix = prefix or ''

    TDeleteRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteRsp.proto_property, errs)
    return self
end

function TDeleteRsp:unpack(_)
end

msg.DeleteRsp = TDeleteRsp

---@class LicenseService.DeleteReq
---@field LicenseId string
local TDeleteReq = {}
TDeleteReq.__index = TDeleteReq
TDeleteReq.group = {}

local function TDeleteReq_from_obj(obj)
    return setmetatable(obj, TDeleteReq)
end

function TDeleteReq.new(LicenseId)
    return TDeleteReq_from_obj({LicenseId = LicenseId})
end
---@param obj LicenseService.DeleteReq
function TDeleteReq:init_from_obj(obj)
    self.LicenseId = obj.LicenseId
end

function TDeleteReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteReq.group)
end

TDeleteReq.from_obj = TDeleteReq_from_obj

TDeleteReq.proto_property = {'LicenseId'}

TDeleteReq.default = {''}

TDeleteReq.struct = {{name = 'LicenseId', is_array = false, struct = nil}}

function TDeleteReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'LicenseId', self.LicenseId, 'string', false, errs)

    TDeleteReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteReq.proto_property, errs)
    return self
end

function TDeleteReq:unpack(_)
    return self.LicenseId
end

msg.DeleteReq = TDeleteReq

---@class LicenseService.ExportRsp
local TExportRsp = {}
TExportRsp.__index = TExportRsp
TExportRsp.group = {}

local function TExportRsp_from_obj(obj)
    return setmetatable(obj, TExportRsp)
end

function TExportRsp.new()
    return TExportRsp_from_obj({})
end
---@param obj LicenseService.ExportRsp
function TExportRsp:init_from_obj(obj)

end

function TExportRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportRsp.group)
end

TExportRsp.from_obj = TExportRsp_from_obj

TExportRsp.proto_property = {}

TExportRsp.default = {}

TExportRsp.struct = {}

function TExportRsp:validate(prefix, errs)
    prefix = prefix or ''

    TExportRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportRsp.proto_property, errs)
    return self
end

function TExportRsp:unpack(_)
end

msg.ExportRsp = TExportRsp

---@class LicenseService.ExportReq
---@field LicenseId string
---@field URI string
---@field Password string
---@field TransferProtocol string
---@field Username string
local TExportReq = {}
TExportReq.__index = TExportReq
TExportReq.group = {}

local function TExportReq_from_obj(obj)
    return setmetatable(obj, TExportReq)
end

function TExportReq.new(LicenseId, URI, Password, TransferProtocol, Username)
    return TExportReq_from_obj({
        LicenseId = LicenseId,
        URI = URI,
        Password = Password,
        TransferProtocol = TransferProtocol,
        Username = Username
    })
end
---@param obj LicenseService.ExportReq
function TExportReq:init_from_obj(obj)
    self.LicenseId = obj.LicenseId
    self.URI = obj.URI
    self.Password = obj.Password
    self.TransferProtocol = obj.TransferProtocol
    self.Username = obj.Username
end

function TExportReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportReq.group)
end

TExportReq.from_obj = TExportReq_from_obj

TExportReq.proto_property = {'LicenseId', 'URI', 'Password', 'TransferProtocol', 'Username'}

TExportReq.default = {'', '', '', '', ''}

TExportReq.struct = {
    {name = 'LicenseId', is_array = false, struct = nil},
    {name = 'URI', is_array = false, struct = nil},
    {name = 'Password', is_array = false, struct = nil},
    {name = 'TransferProtocol', is_array = false, struct = nil},
    {name = 'Username', is_array = false, struct = nil}
}

function TExportReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'LicenseId', self.LicenseId, 'string', false, errs)
    validate.Required(prefix .. 'URI', self.URI, 'string', false, errs)
    validate.Required(prefix .. 'Password', self.Password, 'string', false, errs)
    validate.Required(prefix .. 'TransferProtocol', self.TransferProtocol, 'string', false, errs)
    validate.Required(prefix .. 'Username', self.Username, 'string', false, errs)

    TExportReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportReq.proto_property, errs)
    return self
end

function TExportReq:unpack(_)
    return self.LicenseId, self.URI, self.Password, self.TransferProtocol, self.Username
end

msg.ExportReq = TExportReq

---@class LicenseService.InstallFromLocalRsp
local TInstallFromLocalRsp = {}
TInstallFromLocalRsp.__index = TInstallFromLocalRsp
TInstallFromLocalRsp.group = {}

local function TInstallFromLocalRsp_from_obj(obj)
    return setmetatable(obj, TInstallFromLocalRsp)
end

function TInstallFromLocalRsp.new()
    return TInstallFromLocalRsp_from_obj({})
end
---@param obj LicenseService.InstallFromLocalRsp
function TInstallFromLocalRsp:init_from_obj(obj)

end

function TInstallFromLocalRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInstallFromLocalRsp.group)
end

TInstallFromLocalRsp.from_obj = TInstallFromLocalRsp_from_obj

TInstallFromLocalRsp.proto_property = {}

TInstallFromLocalRsp.default = {}

TInstallFromLocalRsp.struct = {}

function TInstallFromLocalRsp:validate(prefix, errs)
    prefix = prefix or ''

    TInstallFromLocalRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInstallFromLocalRsp.proto_property, errs)
    return self
end

function TInstallFromLocalRsp:unpack(_)
end

msg.InstallFromLocalRsp = TInstallFromLocalRsp

---@class LicenseService.InstallFromLocalReq
---@field Type string
---@field Content string
---@field FileSource string
local TInstallFromLocalReq = {}
TInstallFromLocalReq.__index = TInstallFromLocalReq
TInstallFromLocalReq.group = {}

local function TInstallFromLocalReq_from_obj(obj)
    return setmetatable(obj, TInstallFromLocalReq)
end

function TInstallFromLocalReq.new(Type, Content, FileSource)
    return TInstallFromLocalReq_from_obj({Type = Type, Content = Content, FileSource = FileSource})
end
---@param obj LicenseService.InstallFromLocalReq
function TInstallFromLocalReq:init_from_obj(obj)
    self.Type = obj.Type
    self.Content = obj.Content
    self.FileSource = obj.FileSource
end

function TInstallFromLocalReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInstallFromLocalReq.group)
end

TInstallFromLocalReq.from_obj = TInstallFromLocalReq_from_obj

TInstallFromLocalReq.proto_property = {'Type', 'Content', 'FileSource'}

TInstallFromLocalReq.default = {'', '', ''}

TInstallFromLocalReq.struct = {
    {name = 'Type', is_array = false, struct = nil},
    {name = 'Content', is_array = false, struct = nil},
    {name = 'FileSource', is_array = false, struct = nil}
}

function TInstallFromLocalReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Type', self.Type, 'string', false, errs)
    validate.Required(prefix .. 'Content', self.Content, 'string', false, errs)
    validate.Required(prefix .. 'FileSource', self.FileSource, 'string', false, errs)

    TInstallFromLocalReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInstallFromLocalReq.proto_property, errs)
    return self
end

function TInstallFromLocalReq:unpack(_)
    return self.Type, self.Content, self.FileSource
end

msg.InstallFromLocalReq = TInstallFromLocalReq

---@class LicenseService.InstallFromRemoteRsp
local TInstallFromRemoteRsp = {}
TInstallFromRemoteRsp.__index = TInstallFromRemoteRsp
TInstallFromRemoteRsp.group = {}

local function TInstallFromRemoteRsp_from_obj(obj)
    return setmetatable(obj, TInstallFromRemoteRsp)
end

function TInstallFromRemoteRsp.new()
    return TInstallFromRemoteRsp_from_obj({})
end
---@param obj LicenseService.InstallFromRemoteRsp
function TInstallFromRemoteRsp:init_from_obj(obj)

end

function TInstallFromRemoteRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInstallFromRemoteRsp.group)
end

TInstallFromRemoteRsp.from_obj = TInstallFromRemoteRsp_from_obj

TInstallFromRemoteRsp.proto_property = {}

TInstallFromRemoteRsp.default = {}

TInstallFromRemoteRsp.struct = {}

function TInstallFromRemoteRsp:validate(prefix, errs)
    prefix = prefix or ''

    TInstallFromRemoteRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInstallFromRemoteRsp.proto_property, errs)
    return self
end

function TInstallFromRemoteRsp:unpack(_)
end

msg.InstallFromRemoteRsp = TInstallFromRemoteRsp

---@class LicenseService.InstallFromRemoteReq
---@field LicenseFileURI string
---@field TransferProtocol string
---@field Username string
---@field Password string
local TInstallFromRemoteReq = {}
TInstallFromRemoteReq.__index = TInstallFromRemoteReq
TInstallFromRemoteReq.group = {}

local function TInstallFromRemoteReq_from_obj(obj)
    return setmetatable(obj, TInstallFromRemoteReq)
end

function TInstallFromRemoteReq.new(LicenseFileURI, TransferProtocol, Username, Password)
    return TInstallFromRemoteReq_from_obj({
        LicenseFileURI = LicenseFileURI,
        TransferProtocol = TransferProtocol,
        Username = Username,
        Password = Password
    })
end
---@param obj LicenseService.InstallFromRemoteReq
function TInstallFromRemoteReq:init_from_obj(obj)
    self.LicenseFileURI = obj.LicenseFileURI
    self.TransferProtocol = obj.TransferProtocol
    self.Username = obj.Username
    self.Password = obj.Password
end

function TInstallFromRemoteReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TInstallFromRemoteReq.group)
end

TInstallFromRemoteReq.from_obj = TInstallFromRemoteReq_from_obj

TInstallFromRemoteReq.proto_property = {
    'LicenseFileURI', 'TransferProtocol', 'Username', 'Password'
}

TInstallFromRemoteReq.default = {'', '', '', ''}

TInstallFromRemoteReq.struct = {
    {name = 'LicenseFileURI', is_array = false, struct = nil},
    {name = 'TransferProtocol', is_array = false, struct = nil},
    {name = 'Username', is_array = false, struct = nil},
    {name = 'Password', is_array = false, struct = nil}
}

function TInstallFromRemoteReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'LicenseFileURI', self.LicenseFileURI, 'string', false, errs)
    validate.Required(prefix .. 'TransferProtocol', self.TransferProtocol, 'string', false, errs)
    validate.Required(prefix .. 'Username', self.Username, 'string', false, errs)
    validate.Required(prefix .. 'Password', self.Password, 'string', false, errs)

    TInstallFromRemoteReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TInstallFromRemoteReq.proto_property, errs)
    return self
end

function TInstallFromRemoteReq:unpack(_)
    return self.LicenseFileURI, self.TransferProtocol, self.Username, self.Password
end

msg.InstallFromRemoteReq = TInstallFromRemoteReq

local LicenseService = {}

local Mdb = require 'mc.mdb'

---@class LicenseService: Table
---@field ESN string
LicenseService.LicenseService = Mdb.register_interface('bmc.kepler.LicenseService',
    {ESN = {'s', nil, false, nil}}, {
        InstallFromRemote = {'a{ss}ssss', '', msg.InstallFromRemoteReq, msg.InstallFromRemoteRsp},
        InstallFromLocal = {'a{ss}sss', '', msg.InstallFromLocalReq, msg.InstallFromLocalRsp},
        Export = {'a{ss}sssss', '', msg.ExportReq, msg.ExportRsp},
        Delete = {'a{ss}s', '', msg.DeleteReq, msg.DeleteRsp},
        Revoke = {'a{ss}s', 's', msg.RevokeReq, msg.RevokeRsp}
    }, {})
return LicenseService
