-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class License.GetLicenseInfoRsp
local TGetLicenseInfoRsp = {}
TGetLicenseInfoRsp.__index = TGetLicenseInfoRsp
TGetLicenseInfoRsp.group = {}

local function TGetLicenseInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetLicenseInfoRsp)
end

function TGetLicenseInfoRsp.new()
    return TGetLicenseInfoRsp_from_obj({})
end
---@param obj License.GetLicenseInfoRsp
function TGetLicenseInfoRsp:init_from_obj(obj)

end

function TGetLicenseInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLicenseInfoRsp.group)
end

TGetLicenseInfoRsp.from_obj = TGetLicenseInfoRsp_from_obj

TGetLicenseInfoRsp.proto_property = {}

TGetLicenseInfoRsp.default = {}

TGetLicenseInfoRsp.struct = {}

function TGetLicenseInfoRsp:validate(prefix, errs)
    prefix = prefix or ''

    TGetLicenseInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLicenseInfoRsp.proto_property, errs)
    return self
end

function TGetLicenseInfoRsp:unpack(_)
end

msg.GetLicenseInfoRsp = TGetLicenseInfoRsp

---@class License.GetLicenseInfoReq
local TGetLicenseInfoReq = {}
TGetLicenseInfoReq.__index = TGetLicenseInfoReq
TGetLicenseInfoReq.group = {}

local function TGetLicenseInfoReq_from_obj(obj)
    return setmetatable(obj, TGetLicenseInfoReq)
end

function TGetLicenseInfoReq.new()
    return TGetLicenseInfoReq_from_obj({})
end
---@param obj License.GetLicenseInfoReq
function TGetLicenseInfoReq:init_from_obj(obj)

end

function TGetLicenseInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetLicenseInfoReq.group)
end

TGetLicenseInfoReq.from_obj = TGetLicenseInfoReq_from_obj

TGetLicenseInfoReq.proto_property = {}

TGetLicenseInfoReq.default = {}

TGetLicenseInfoReq.struct = {}

function TGetLicenseInfoReq:validate(prefix, errs)
    prefix = prefix or ''

    TGetLicenseInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetLicenseInfoReq.proto_property, errs)
    return self
end

function TGetLicenseInfoReq:unpack(_)
end

msg.GetLicenseInfoReq = TGetLicenseInfoReq

local License = {}

local Mdb = require 'mc.mdb'

---@class License: Table
License.License = Mdb.register_interface('bmc.kepler.LicenseService.License', {}, {
    GetLicenseInfo = {'a{ss}', '', msg.GetLicenseInfoReq, msg.GetLicenseInfoRsp}
}, {})
return License
