-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local IpmiMsg = {}

---@class IpmiMsg.IpmiCmdReq
---@field ChanType integer
---@field Instance integer
---@field NetFn integer
---@field Lun integer
---@field Cmd integer
---@field Payload string
local TIpmiCmdReq = {}
TIpmiCmdReq.__index = TIpmiCmdReq
TIpmiCmdReq.group = {}

local function TIpmiCmdReq_from_obj(obj)
    return setmetatable(obj, TIpmiCmdReq)
end

function TIpmiCmdReq.new(ChanType, Instance, NetFn, Lun, Cmd, Payload)
    return TIpmiCmdReq_from_obj({
        ChanType = ChanType,
        Instance = Instance,
        NetFn = NetFn,
        Lun = Lun,
        Cmd = Cmd,
        Payload = Payload
    })
end
---@param obj IpmiMsg.IpmiCmdReq
function TIpmiCmdReq:init_from_obj(obj)
    self.ChanType = obj.ChanType
    self.Instance = obj.Instance
    self.NetFn = obj.NetFn
    self.Lun = obj.Lun
    self.Cmd = obj.Cmd
    self.Payload = obj.Payload
end

function TIpmiCmdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpmiCmdReq.group)
end

TIpmiCmdReq.from_obj = TIpmiCmdReq_from_obj

TIpmiCmdReq.proto_property = {'ChanType', 'Instance', 'NetFn', 'Lun', 'Cmd', 'Payload'}

TIpmiCmdReq.default = {0, 0, 0, 0, 0, ''}

TIpmiCmdReq.struct = {
    {name = 'ChanType', is_array = false, struct = nil},
    {name = 'Instance', is_array = false, struct = nil},
    {name = 'NetFn', is_array = false, struct = nil},
    {name = 'Lun', is_array = false, struct = nil}, {name = 'Cmd', is_array = false, struct = nil},
    {name = 'Payload', is_array = false, struct = nil}
}

function TIpmiCmdReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'ChanType', self.ChanType, 'uint8', false, errs)
    validate.Required(prefix .. 'Instance', self.Instance, 'uint8', false, errs)
    validate.Required(prefix .. 'NetFn', self.NetFn, 'uint8', false, errs)
    validate.Required(prefix .. 'Lun', self.Lun, 'uint8', false, errs)
    validate.Required(prefix .. 'Cmd', self.Cmd, 'uint8', false, errs)
    validate.Required(prefix .. 'Payload', self.Payload, 'bytes', false, errs)

    TIpmiCmdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpmiCmdReq.proto_property, errs)
    return self
end

function TIpmiCmdReq:unpack(_)
    return self.ChanType, self.Instance, self.NetFn, self.Lun, self.Cmd, self.Payload
end

IpmiMsg.IpmiCmdReq = TIpmiCmdReq

---@class IpmiMsg.IpmiCmdRsp
---@field CompletionCode integer
---@field Payload string
local TIpmiCmdRsp = {}
TIpmiCmdRsp.__index = TIpmiCmdRsp
TIpmiCmdRsp.group = {}

local function TIpmiCmdRsp_from_obj(obj)
    return setmetatable(obj, TIpmiCmdRsp)
end

function TIpmiCmdRsp.new(CompletionCode, Payload)
    return TIpmiCmdRsp_from_obj({CompletionCode = CompletionCode, Payload = Payload})
end
---@param obj IpmiMsg.IpmiCmdRsp
function TIpmiCmdRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Payload = obj.Payload
end

function TIpmiCmdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpmiCmdRsp.group)
end

TIpmiCmdRsp.from_obj = TIpmiCmdRsp_from_obj

TIpmiCmdRsp.proto_property = {'CompletionCode', 'Payload'}

TIpmiCmdRsp.default = {0, ''}

TIpmiCmdRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil},
    {name = 'Payload', is_array = false, struct = nil}
}

function TIpmiCmdRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs)
    validate.Required(prefix .. 'Payload', self.Payload, 'bytes', false, errs)

    TIpmiCmdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpmiCmdRsp.proto_property, errs)
    return self
end

function TIpmiCmdRsp:unpack(_)
    return self.CompletionCode, self.Payload
end

IpmiMsg.IpmiCmdRsp = TIpmiCmdRsp

---@class IpmiMsg.IpmiRouteReq
---@field Req string
---@field Ctx string
local TIpmiRouteReq = {}
TIpmiRouteReq.__index = TIpmiRouteReq
TIpmiRouteReq.group = {}

local function TIpmiRouteReq_from_obj(obj)
    return setmetatable(obj, TIpmiRouteReq)
end

function TIpmiRouteReq.new(Req, Ctx)
    return TIpmiRouteReq_from_obj({Req = Req, Ctx = Ctx})
end
---@param obj IpmiMsg.IpmiRouteReq
function TIpmiRouteReq:init_from_obj(obj)
    self.Req = obj.Req
    self.Ctx = obj.Ctx
end

function TIpmiRouteReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpmiRouteReq.group)
end

TIpmiRouteReq.from_obj = TIpmiRouteReq_from_obj

TIpmiRouteReq.proto_property = {'Req', 'Ctx'}

TIpmiRouteReq.default = {'', ''}

TIpmiRouteReq.struct = {
    {name = 'Req', is_array = false, struct = nil}, {name = 'Ctx', is_array = false, struct = nil}
}

function TIpmiRouteReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Req', self.Req, 'bytes', false, errs)
    validate.Required(prefix .. 'Ctx', self.Ctx, 'bytes', false, errs)

    TIpmiRouteReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpmiRouteReq.proto_property, errs)
    return self
end

function TIpmiRouteReq:unpack(_)
    return self.Req, self.Ctx
end

IpmiMsg.IpmiRouteReq = TIpmiRouteReq

---@class IpmiMsg.IpmiRouteRsp
---@field Rsp string
local TIpmiRouteRsp = {}
TIpmiRouteRsp.__index = TIpmiRouteRsp
TIpmiRouteRsp.group = {}

local function TIpmiRouteRsp_from_obj(obj)
    return setmetatable(obj, TIpmiRouteRsp)
end

function TIpmiRouteRsp.new(Rsp)
    return TIpmiRouteRsp_from_obj({Rsp = Rsp})
end
---@param obj IpmiMsg.IpmiRouteRsp
function TIpmiRouteRsp:init_from_obj(obj)
    self.Rsp = obj.Rsp
end

function TIpmiRouteRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TIpmiRouteRsp.group)
end

TIpmiRouteRsp.from_obj = TIpmiRouteRsp_from_obj

TIpmiRouteRsp.proto_property = {'Rsp'}

TIpmiRouteRsp.default = {''}

TIpmiRouteRsp.struct = {{name = 'Rsp', is_array = false, struct = nil}}

function TIpmiRouteRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Rsp', self.Rsp, 'bytes', false, errs)

    TIpmiRouteRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TIpmiRouteRsp.proto_property, errs)
    return self
end

function TIpmiRouteRsp:unpack(_)
    return self.Rsp
end

IpmiMsg.IpmiRouteRsp = TIpmiRouteRsp

return IpmiMsg
