-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local HwproxyInterface = require 'mdb.bmc.kepler.Hwproxy.HwproxyInterface'

local childs = {}
local Hwproxy = {childs = childs}

local Mdb = require 'mc.mdb'

local TAccessor = Mdb.register_object('/bmc/kepler/Accessor/:Id',
    {{name = 'Accessor', interface = HwproxyInterface.IAccessor}})
Hwproxy.Accessor = TAccessor

function TAccessor:ctor(Id)
    self.path = '/bmc/kepler/Accessor/' .. Id .. ''
end

local TScanner = Mdb.register_object('/bmc/kepler/Scanner/:Id',
    {{name = 'Scanner', interface = HwproxyInterface.IScanner}})
Hwproxy.Scanner = TScanner

function TScanner:ctor(Id)
    self.path = '/bmc/kepler/Scanner/' .. Id .. ''
end

local TI2c = Mdb.register_object('/bmc/kepler/Bus/I2c/:Id',
    {{name = 'I2c', interface = HwproxyInterface.IBus}})
Hwproxy.I2c = TI2c

function TI2c:ctor(Id)
    self.path = '/bmc/kepler/Bus/I2c/' .. Id .. ''
end

local THisport = Mdb.register_object('/bmc/kepler/Bus/Hisport/:Id',
    {{name = 'Hisport', interface = HwproxyInterface.IBus}})
Hwproxy.Hisport = THisport

function THisport:ctor(Id)
    self.path = '/bmc/kepler/Bus/Hisport/' .. Id .. ''
end

local TSMC = Mdb.register_object('/bmc/kepler/Chip/SMC',
    {{name = 'Rtc', interface = HwproxyInterface.IRtc}})
Hwproxy.SMC = TSMC

function TSMC:ctor()
    self.path = '/bmc/kepler/Chip/SMC'
end

local TSmc = Mdb.register_object('/bmc/kepler/Chip/Smc/:Id',
    {{name = 'Smc', interface = HwproxyInterface.IChip}})
Hwproxy.Smc = TSmc

function TSmc:ctor(Id)
    self.path = '/bmc/kepler/Chip/Smc/' .. Id .. ''
end

local TEeprom = Mdb.register_object('/bmc/kepler/Chip/Eeprom/:Id', {
    {name = 'BlockIO', interface = HwproxyInterface.IBlockIO},
    {name = 'Eeprom', interface = HwproxyInterface.IChip}
})
Hwproxy.Eeprom = TEeprom

function TEeprom:ctor(Id)
    self.path = '/bmc/kepler/Chip/Eeprom/' .. Id .. ''
end

local TPca9544 = Mdb.register_object('/bmc/kepler/Chip/Pca9544/:Id',
    {{name = 'Pca9544', interface = HwproxyInterface.IChip}})
Hwproxy.Pca9544 = TPca9544

function TPca9544:ctor(Id)
    self.path = '/bmc/kepler/Chip/Pca9544/' .. Id .. ''
end

local TPca9545 = Mdb.register_object('/bmc/kepler/Chip/Pca9545/:Id',
    {{name = 'Pca9545', interface = HwproxyInterface.IChip}})
Hwproxy.Pca9545 = TPca9545

function TPca9545:ctor(Id)
    self.path = '/bmc/kepler/Chip/Pca9545/' .. Id .. ''
end

local TPca9555 = Mdb.register_object('/bmc/kepler/Chip/Pca9555/:Id',
    {{name = 'Pca9555', interface = HwproxyInterface.IChip}})
Hwproxy.Pca9555 = TPca9555

function TPca9555:ctor(Id)
    self.path = '/bmc/kepler/Chip/Pca9555/' .. Id .. ''
end

local TVrd = Mdb.register_object('/bmc/kepler/Chip/Vrd/:Id',
    {{name = 'Vrd', interface = HwproxyInterface.IChip}})
Hwproxy.Vrd = TVrd

function TVrd:ctor(Id)
    self.path = '/bmc/kepler/Chip/Vrd/' .. Id .. ''
end

local TLm75 = Mdb.register_object('/bmc/kepler/Chip/Lm75/:Id',
    {{name = 'Lm75', interface = HwproxyInterface.IChip}})
Hwproxy.Lm75 = TLm75

function TLm75:ctor(Id)
    self.path = '/bmc/kepler/Chip/Lm75/' .. Id .. ''
end

local TAds78 = Mdb.register_object('/bmc/kepler/Chip/Ads78/:Id',
    {{name = 'Ads78', interface = HwproxyInterface.IChip}})
Hwproxy.Ads78 = TAds78

function TAds78:ctor(Id)
    self.path = '/bmc/kepler/Chip/Ads78/' .. Id .. ''
end

local TCpldRegister = Mdb.register_object('/bmc/kepler/Chip/CpldRegister/:Id', {
    {name = 'CpldRegister', interface = HwproxyInterface.IChip}
})
Hwproxy.CpldRegister = TCpldRegister

function TCpldRegister:ctor(Id)
    self.path = '/bmc/kepler/Chip/CpldRegister/' .. Id .. ''
end

local TChip = Mdb.register_object('/bmc/kepler/Chip/:Id',
    {{name = 'Chip', interface = HwproxyInterface.IChip}})
Hwproxy.Chip = TChip

function TChip:ctor(Id)
    self.path = '/bmc/kepler/Chip/' .. Id .. ''
end

local TCpld = Mdb.register_object('/bmc/kepler/Chip/Cpld/:Id', {
    {name = 'BlockIO', interface = HwproxyInterface.IBlockIO},
    {name = 'Chip', interface = HwproxyInterface.IChip},
    {name = 'JtagTarget', interface = HwproxyInterface.IJtag}
})
Hwproxy.Cpld = TCpld

function TCpld:ctor(Id)
    self.path = '/bmc/kepler/Chip/Cpld/' .. Id .. ''
end

local TI2CMux = Mdb.register_object('/bmc/kepler/Mux/I2cMux/:Id',
    {{name = 'I2CMux', interface = HwproxyInterface.II2CMux}})
Hwproxy.I2CMux = TI2CMux

function TI2CMux:ctor(Id)
    self.path = '/bmc/kepler/Mux/I2cMux/' .. Id .. ''
end

return Hwproxy
