-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local Hwproxy = {}

local Mdb = require 'mc.mdb'

local HwproxyMsg = require 'mdb.bmc.kepler.Hwproxy.types.message'

---@class IBlockIO: Table
Hwproxy.IBlockIO = Mdb.register_interface('bmc.kepler.Chip.BlockIO', {}, {
    Read = {'a{ss}uu', 'ay', HwproxyMsg.BlockReadReq, HwproxyMsg.BlockReadRsp},
    Write = {'a{ss}uay', '', HwproxyMsg.BlockWriteReq, nil},
    WriteRead = {'a{ss}uay', 'ay', HwproxyMsg.BlockWriteReq, HwproxyMsg.BlockReadRsp}
}, {})

local HwproxyMsg = require 'mdb.bmc.kepler.Hwproxy.types.message'

---@class IJtag: Table
Hwproxy.IJtag = Mdb.register_interface('bmc.kepler.Chip.JtagTarget', {}, {
    GetChipIdcode = {'a{ss}', 'au', nil, HwproxyMsg.GetChipIdcodeRsp},
    SetTargetNumber = {'a{ss}u', '', HwproxyMsg.SetTargetNumberReq, nil},
    SetBypassMode = {'a{ss}b', '', HwproxyMsg.SetBypassModeReq, nil}
}, {})

---@class IAccessor: Table
---@field Value integer
Hwproxy.IAccessor = Mdb.register_interface('bmc.kepler.Accessor', {Value = {'t', nil, false, nil}},
    {}, {})

---@class IScanner: Table
---@field Value integer
Hwproxy.IScanner = Mdb.register_interface('bmc.kepler.Scanner', {Value = {'t', nil, true, nil}}, {},
    {})

---@class IBus: Table
Hwproxy.IBus = Mdb.register_interface('bmc.kepler.Bus', {}, {}, {})

---@class IRtc: Table
---@field RtcTimestamp integer[]
Hwproxy.IRtc = Mdb.register_interface('bmc.kepler.Chip.Rtc',
    {RtcTimestamp = {'ay', nil, true, nil}}, {}, {})

---@class IChip: Table
---@field HealthStatus integer
---@field PowerStatus integer
---@field SelfTestResult integer
Hwproxy.IChip = Mdb.register_interface('bmc.kepler.Chip', {
    HealthStatus = {'y', nil, false, 1},
    PowerStatus = {'y', nil, false, 1},
    SelfTestResult = {'y', nil, false, 1}
}, {}, {})

---@class II2CMux: Table
Hwproxy.II2CMux = Mdb.register_interface('bmc.kepler.Mux.I2cMux', {}, {}, {})

return Hwproxy
