-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class Nms.SubmitTestEventRsp
local TSubmitTestEventRsp = {}
TSubmitTestEventRsp.__index = TSubmitTestEventRsp
TSubmitTestEventRsp.group = {}

local function TSubmitTestEventRsp_from_obj(obj)
    return setmetatable(obj, TSubmitTestEventRsp)
end

function TSubmitTestEventRsp.new()
    return TSubmitTestEventRsp_from_obj({})
end
---@param obj Nms.SubmitTestEventRsp
function TSubmitTestEventRsp:init_from_obj(obj)

end

function TSubmitTestEventRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubmitTestEventRsp.group)
end

TSubmitTestEventRsp.from_obj = TSubmitTestEventRsp_from_obj

TSubmitTestEventRsp.proto_property = {}

TSubmitTestEventRsp.default = {}

TSubmitTestEventRsp.struct = {}

function TSubmitTestEventRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSubmitTestEventRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubmitTestEventRsp.proto_property, errs)
    return self
end

function TSubmitTestEventRsp:unpack(_)
end

msg.SubmitTestEventRsp = TSubmitTestEventRsp

---@class Nms.SubmitTestEventReq
local TSubmitTestEventReq = {}
TSubmitTestEventReq.__index = TSubmitTestEventReq
TSubmitTestEventReq.group = {}

local function TSubmitTestEventReq_from_obj(obj)
    return setmetatable(obj, TSubmitTestEventReq)
end

function TSubmitTestEventReq.new()
    return TSubmitTestEventReq_from_obj({})
end
---@param obj Nms.SubmitTestEventReq
function TSubmitTestEventReq:init_from_obj(obj)

end

function TSubmitTestEventReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSubmitTestEventReq.group)
end

TSubmitTestEventReq.from_obj = TSubmitTestEventReq_from_obj

TSubmitTestEventReq.proto_property = {}

TSubmitTestEventReq.default = {}

TSubmitTestEventReq.struct = {}

function TSubmitTestEventReq:validate(prefix, errs)
    prefix = prefix or ''

    TSubmitTestEventReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSubmitTestEventReq.proto_property, errs)
    return self
end

function TSubmitTestEventReq:unpack(_)
end

msg.SubmitTestEventReq = TSubmitTestEventReq

local Nms = {}

local Mdb = require 'mc.mdb'

---@class Nms: Table
---@field Enabled boolean
---@field BobEnabled boolean
---@field Address string
---@field Port integer
Nms.Nms = Mdb.register_interface('bmc.kepler.EventService.Subscriptions.Snmp.Nms', {
    Enabled = {'b', nil, false, False},
    BobEnabled = {'b', nil, false, False},
    Address = {'s', nil, false, nil},
    Port = {'q', nil, false, 162}
}, {SubmitTestEvent = {'a{ss}', '', msg.SubmitTestEventReq, msg.SubmitTestEventRsp}}, {})
return Nms
