-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class Role.SetRolePrivilegeRsp
local TSetRolePrivilegeRsp = {}
TSetRolePrivilegeRsp.__index = TSetRolePrivilegeRsp
TSetRolePrivilegeRsp.group = {}

local function TSetRolePrivilegeRsp_from_obj(obj)
    return setmetatable(obj, TSetRolePrivilegeRsp)
end

function TSetRolePrivilegeRsp.new()
    return TSetRolePrivilegeRsp_from_obj({})
end
---@param obj Role.SetRolePrivilegeRsp
function TSetRolePrivilegeRsp:init_from_obj(obj)

end

function TSetRolePrivilegeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetRolePrivilegeRsp.group)
end

TSetRolePrivilegeRsp.from_obj = TSetRolePrivilegeRsp_from_obj

TSetRolePrivilegeRsp.proto_property = {}

TSetRolePrivilegeRsp.default = {}

TSetRolePrivilegeRsp.struct = {}

function TSetRolePrivilegeRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSetRolePrivilegeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetRolePrivilegeRsp.proto_property, errs)
    return self
end

function TSetRolePrivilegeRsp:unpack(_)
end

msg.SetRolePrivilegeRsp = TSetRolePrivilegeRsp

---@class Role.SetRolePrivilegeReq
---@field PrivilegeType integer
---@field PrivilegeValue boolean
local TSetRolePrivilegeReq = {}
TSetRolePrivilegeReq.__index = TSetRolePrivilegeReq
TSetRolePrivilegeReq.group = {}

local function TSetRolePrivilegeReq_from_obj(obj)
    return setmetatable(obj, TSetRolePrivilegeReq)
end

function TSetRolePrivilegeReq.new(PrivilegeType, PrivilegeValue)
    return TSetRolePrivilegeReq_from_obj({
        PrivilegeType = PrivilegeType,
        PrivilegeValue = PrivilegeValue
    })
end
---@param obj Role.SetRolePrivilegeReq
function TSetRolePrivilegeReq:init_from_obj(obj)
    self.PrivilegeType = obj.PrivilegeType
    self.PrivilegeValue = obj.PrivilegeValue
end

function TSetRolePrivilegeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetRolePrivilegeReq.group)
end

TSetRolePrivilegeReq.from_obj = TSetRolePrivilegeReq_from_obj

TSetRolePrivilegeReq.proto_property = {'PrivilegeType', 'PrivilegeValue'}

TSetRolePrivilegeReq.default = {0, false}

TSetRolePrivilegeReq.struct = {
    {name = 'PrivilegeType', is_array = false, struct = nil},
    {name = 'PrivilegeValue', is_array = false, struct = nil}
}

function TSetRolePrivilegeReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'PrivilegeType', self.PrivilegeType, 'uint8', false, errs)
    validate.Required(prefix .. 'PrivilegeValue', self.PrivilegeValue, 'bool', false, errs)

    TSetRolePrivilegeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetRolePrivilegeReq.proto_property, errs)
    return self
end

function TSetRolePrivilegeReq:unpack(_)
    return self.PrivilegeType, self.PrivilegeValue
end

msg.SetRolePrivilegeReq = TSetRolePrivilegeReq

local Role = {}

local Mdb = require 'mc.mdb'

---@class Role: Table
---@field RolePrivilege string[]
Role.Role = Mdb.register_interface('bmc.kepler.AccountService.Role',
    {RolePrivilege = {'as', nil, true, nil}}, {
        SetRolePrivilege = {'a{ss}yb', '', msg.SetRolePrivilegeReq, msg.SetRolePrivilegeRsp}
    }, {})
return Role
