-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class RemoteGroup.DeleteRsp
local TDeleteRsp = {}
TDeleteRsp.__index = TDeleteRsp
TDeleteRsp.group = {}

local function TDeleteRsp_from_obj(obj)
    return setmetatable(obj, TDeleteRsp)
end

function TDeleteRsp.new()
    return TDeleteRsp_from_obj({})
end
---@param obj RemoteGroup.DeleteRsp
function TDeleteRsp:init_from_obj(obj)

end

function TDeleteRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteRsp.group)
end

TDeleteRsp.from_obj = TDeleteRsp_from_obj

TDeleteRsp.proto_property = {}

TDeleteRsp.default = {}

TDeleteRsp.struct = {}

function TDeleteRsp:validate(prefix, errs)
    prefix = prefix or ''

    TDeleteRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteRsp.proto_property, errs)
    return self
end

function TDeleteRsp:unpack(_)
end

msg.DeleteRsp = TDeleteRsp

---@class RemoteGroup.DeleteReq
local TDeleteReq = {}
TDeleteReq.__index = TDeleteReq
TDeleteReq.group = {}

local function TDeleteReq_from_obj(obj)
    return setmetatable(obj, TDeleteReq)
end

function TDeleteReq.new()
    return TDeleteReq_from_obj({})
end
---@param obj RemoteGroup.DeleteReq
function TDeleteReq:init_from_obj(obj)

end

function TDeleteReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteReq.group)
end

TDeleteReq.from_obj = TDeleteReq_from_obj

TDeleteReq.proto_property = {}

TDeleteReq.default = {}

TDeleteReq.struct = {}

function TDeleteReq:validate(prefix, errs)
    prefix = prefix or ''

    TDeleteReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteReq.proto_property, errs)
    return self
end

function TDeleteReq:unpack(_)
end

msg.DeleteReq = TDeleteReq

local RemoteGroup = {}

local Mdb = require 'mc.mdb'

---@class RemoteGroup: Table
---@field GroupType integer
---@field ControllerId integer
---@field SID string
---@field Name string
---@field UserRoleId integer
---@field Folder string
---@field PermitRuleIds string[]
---@field LoginInterface string[]
RemoteGroup.RemoteGroup = Mdb.register_interface('bmc.kepler.AccountService.RemoteGroup', {
    GroupType = {'y', nil, true, nil},
    ControllerId = {'y', nil, true, nil},
    SID = {'s', nil, false, nil},
    Name = {'s', nil, false, nil},
    UserRoleId = {'y', nil, false, nil},
    Folder = {'s', nil, false, nil},
    PermitRuleIds = {'as', nil, false, nil},
    LoginInterface = {'as', nil, false, nil}
}, {Delete = {'a{ss}', '', msg.DeleteReq, msg.DeleteRsp}}, {})
return RemoteGroup
