-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class IDemoExtend.Method3Rsp
---@field r5 string
local TMethod3Rsp = {}
TMethod3Rsp.__index = TMethod3Rsp
TMethod3Rsp.group = {}

local function TMethod3Rsp_from_obj(obj)
    return setmetatable(obj, TMethod3Rsp)
end

function TMethod3Rsp.new(r5)
    return TMethod3Rsp_from_obj({r5 = r5})
end
---@param obj IDemoExtend.Method3Rsp
function TMethod3Rsp:init_from_obj(obj)
    self.r5 = obj.r5
end

function TMethod3Rsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMethod3Rsp.group)
end

TMethod3Rsp.from_obj = TMethod3Rsp_from_obj

TMethod3Rsp.proto_property = {'r5'}

TMethod3Rsp.default = {''}

TMethod3Rsp.struct = {{name = 'r5', is_array = false, struct = nil}}

function TMethod3Rsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'r5', self.r5, 'string', false, errs)

    TMethod3Rsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMethod3Rsp.proto_property, errs)
    return self
end

function TMethod3Rsp:unpack(_)
    return self.r5
end

msg.Method3Rsp = TMethod3Rsp

---@class IDemoExtend.Method3Req
---@field p5 string
local TMethod3Req = {}
TMethod3Req.__index = TMethod3Req
TMethod3Req.group = {}

local function TMethod3Req_from_obj(obj)
    return setmetatable(obj, TMethod3Req)
end

function TMethod3Req.new(p5)
    return TMethod3Req_from_obj({p5 = p5})
end
---@param obj IDemoExtend.Method3Req
function TMethod3Req:init_from_obj(obj)
    self.p5 = obj.p5
end

function TMethod3Req:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMethod3Req.group)
end

TMethod3Req.from_obj = TMethod3Req_from_obj

TMethod3Req.proto_property = {'p5'}

TMethod3Req.default = {''}

TMethod3Req.struct = {{name = 'p5', is_array = false, struct = nil}}

function TMethod3Req:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'p5', self.p5, 'string', false, errs)

    TMethod3Req:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMethod3Req.proto_property, errs)
    return self
end

function TMethod3Req:unpack(_)
    return self.p5
end

msg.Method3Req = TMethod3Req

local IDemoExtend = {}

local Mdb = require 'mc.mdb'

---@class IDemoExtend: Table
---@field p2 integer[]
IDemoExtend.IDemoExtend = Mdb.register_interface('bmc.demo.IDemoExtend',
    {p2 = {'ay', nil, false, nil}}, {Method3 = {'a{ss}s', 's', msg.Method3Req, msg.Method3Rsp}}, {})
return IDemoExtend
