-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local function_get_version = require 'external_interface.function_get_version'
local client = require 'manufacture.client'
local file_sec = require 'utils.file'
local json = require 'cjson'

local GetFirmwareInfoObjects = client.GetFirmwareInfoObjects
local open_s = file_sec.open_s
local decode = json.decode

Test_function_get_version = {}

function Test_function_get_version:setUp()
    
end

function Test_function_get_version:teardownClass()
    client.GetFirmwareInfoObjects = GetFirmwareInfoObjects
    file_sec.open_s = open_s
    json.decode = decode
end

function Test_function_get_version:test_get_version_no_file()
    local ctx = {
        HostId = 1
    }
    client.GetFirmwareInfoObjects = function ()
        return nil
    end
    file_sec.open_s = function ()
        return nil
    end
    function_get_version.get_version_by_type(1, 1, ctx)
end

function Test_function_get_version:test_get_version_successed()
    local ctx = {
        HostId = 1
    }
    local json_data = {
        Version = 1
    }
    local file = {
        read = function (...)
            return 1
        end,
        close = function (...)
            return false
        end
    }
    client.GetFirmwareInfoObjects = function ()
        return nil
    end
    file_sec.open_s = function ()
        return file
    end
    json.decode = function (...)
        return json_data
    end
    function_get_version.get_version_by_type(1, 1, ctx)
end

function Test_function_get_version:test_get_version_success()
    local ctx = {
        HostId = 1
    }
    local file = {
        read = function (...)
            return 1
        end,
        close = function (...)
            return false
        end
    }
    client.GetFirmwareInfoObjects = function ()
        return nil
    end
    file_sec.open_s = function ()
        return file
    end
    json.decode = function (...)
        error()
    end
    function_get_version.get_version_by_type(1, 1, ctx)
end

function Test_function_get_version:test_get_version_not_data()
    local ctx = {
        HostId = 1
    }
    local file = {
        read = function (...)
            return 1
        end,
        close = function (...)
            return false
        end
    }
    client.GetFirmwareInfoObjects = function ()
        return nil
    end
    file_sec.open_s = function ()
        return file
    end
    json.decode = function (...)
        return nil
    end
    function_get_version.get_version_by_type(1, 1, ctx)
end