-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local singleton = require 'mc.singleton'

local devcie_chip_service = {}
devcie_chip_service.__index = devcie_chip_service

function devcie_chip_service.new()
    return setmetatable({device_chips = {}}, devcie_chip_service)
end

function devcie_chip_service:on_add_object(class_name, object, position)
    if class_name == 'DeviceChip' then
        table.insert(self.device_chips, object)
    end
end

function devcie_chip_service:set_device_chip_by_type_slot(type, slot, data)
    if not next(self.device_chips) then
        return false
    end
    for _, device in pairs(self.device_chips) do
        if device.DeviceType == type and device.Slot == slot then
            device.Chip = data
            return true
        end
    end
    return false
end

function devcie_chip_service:get_device_chip_by_type_slot(type, slot)
    if not next(self.device_chips) then
        return false
    end
    for _, device in pairs(self.device_chips) do
        if device.DeviceType == type and device.Slot == slot then
            return true, device.Chip
        end
    end
    return false
end

return singleton(devcie_chip_service)